//rpld.h:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2009-2010
 *
 *  This file is part of RoarAudio PlayList Daemon,
 *  a playlist management daemon for RoarAudio.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef _RPLD_RPLD_H_
#define _RPLD_RPLD_H_

#include <roaraudio.h>
#include <time.h>

#ifdef HAVE_LIB_UUID
#include <uuid/uuid.h>
#endif

#include "playlist.h"
#include "fformat.h"
#include "playback.h"
#include "proto_simple_vio.h"
#include "proto_simple.h"
#include "proto_mpd.h"
#include "client.h"
#include "network.h"
#include "store.h"
#include "autoqueue.h"
#include "yield.h"
#include "rpldslp.h"

#define MAX_PLAYLISTS 16

#define POINTER_DEFAULT      0
#define POINTER_CURRENT      1
#define POINTER_STARTUP      2
#define POINTER_TEMP         3

#define POINTER_NUM          4

struct rpld_playlist * g_queue, * g_history;
struct rpld_playlist * g_playlists[MAX_PLAYLISTS];

struct rpld_pointerarray {
 char * name;
 struct rpld_playlist_pointer * pointer;
} g_pointer[POINTER_NUM];

int          g_role;

size_t       g_histsize;

volatile int g_alive;

#if defined(ROAR_HAVE_SETGID) && defined(ROAR_HAVE_IO_POSIX)
struct group   * g_grp;
#endif
#if defined(ROAR_HAVE_SETUID) && defined(ROAR_HAVE_IO_POSIX)
struct passwd  * g_pwd;
#endif

#endif

//ll
