//rpldslp.c:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2009-2012
 *
 *  This file is part of RoarAudio PlayList Daemon,
 *  a playlist management daemon for RoarAudio.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#include "rpld.h"

#ifdef HAVE_LIB_SLP
void register_slp_callback(SLPHandle hslp, SLPError errcode, void * cookie) {
 (void)hslp;

 /* return the error code in the cookie */
 *(SLPError*)cookie = errcode;
}


int register_slp (int unreg, const char * sockname) {
 static int regged = 0;
 static const char * sn = NULL;
 SLPError err;
 SLPError callbackerr;
 SLPHandle hslp;
 char addr[1024];

 if ( sockname != NULL )
  sn = sockname;

 snprintf(addr, sizeof(addr), RPLD_SLP_TYPE_RPLD "://%s", sn);

 err = SLPOpen("en", SLP_FALSE, &hslp);

 if (err != SLP_OK) {
  ROAR_ERR("Error opening slp handle: Error #%i", err);
  return -1;
 }

 if (!unreg) {
  err = SLPReg(hslp,
               addr,
               SLP_LIFETIME_MAXIMUM,
               NULL,
               "", /* attributes */
               SLP_TRUE,
               register_slp_callback,
               &callbackerr);
  regged = 1;
 } else if ( unreg && regged ) {
  err = SLPDereg(hslp, addr, register_slp_callback, &callbackerr);
  regged = 0;
 } else {
  SLPClose(hslp);
  return -1;
 }

 /* err may contain an error code that occurred as the slp library    */
 /* _prepared_ to make the call.                                     */
 if ( err != SLP_OK ) {
  ROAR_ERR("Error (de)registering service with slp: Error #%i", err);
  return -1;
 }

 /* callbackerr may contain an error code (that was assigned through */
 /* the callback cookie) that occurred as slp packets were sent on    */
 /* the wire */
 if (callbackerr != SLP_OK) {
  ROAR_ERR("Error (de)registering service with slp: Error #%i", callbackerr);
  return -1;
 }

 SLPClose(hslp);
 return 0;
}
#endif

//ll
