//playback.h:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2009-2012
 *
 *  This file is part of RoarAudio PlayList Daemon,
 *  a playlist management daemon for RoarAudio.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#ifndef _RPLD_PLAYBACK_H_
#define _RPLD_PLAYBACK_H_

#define PLAYBACK_PAUSE_TRUE      1
#define PLAYBACK_PAUSE_FALSE     0
#define PLAYBACK_PAUSE_TOGGLE    2

struct rpld_queue {
 size_t refc;
 int playing;
 size_t stop_offset;
 int kick_on_stop;
 int role;  // conf.
 int mixer; // conf.
 struct rpld_playlist   * history; // conf.
 struct rpld_backend    * backend; // conf.
 struct roar_stream       stream;
 struct {
  struct roar_vio_calls   file;
  struct roar_vio_calls   stream;
  struct roar_vio_calls   filter;
  struct roar_vio_calls * fp;
 } io;
 uint16_t volume_mono; // conf., scale is 2^16-1
 struct rpld_playlist_entry ple;
 size_t                     ple_mduc;
 struct {
  struct rpld_playlist_pointer * currentptr;
  struct rpld_playlist_pointer * defaultptr;
  struct rpld_playlist_pointer * startupptr;
 } pointers;
};

int  playback_preinit(void);
int  playback_init(void);
void playback_uninit(void);

void playback_set_role(pli_t queue, const int role);

struct roar_audio_info * playback_get_codechelper_info(void);


void playback_check(int block);

int  playback_add_queue(struct rpld_playlist * pl, const char * backend, int mixer, struct rpld_playlist * history);
int  playback_del_queue(struct rpld_playlist * pl);

int  playback_has_queue(pli_t queue);

int  playback_set_pointer(pli_t queue, int pointer, struct rpld_playlist_pointer * plp);
struct rpld_playlist_pointer * playback_get_pointer(pli_t queue, int pointer);

// start or stop all queues.
void playback_play_all(void);
void playback_stop_all(size_t offset, int kick);

// test if at least one queue is playing.
int  playback_is_playing_any(void);

int  playback_play(pli_t queue);
int  playback_next(pli_t queue);
int  playback_prev(pli_t queue);
int  playback_stop(pli_t queue, size_t offset, int kick);
int  playback_pause(pli_t queue, int how);

int  playback_is_playing(pli_t queue);
char * playback_stream_identifier(pli_t queue);

int  playback_is_pause(pli_t queue);

int  playback_set_volume(pli_t queue);

int  playback_set_volume_mu16(pli_t queue, uint16_t mono); /* relative to 2^16-1 */
int  playback_set_volume_mpc(pli_t queue, int pc);         /* in % */

uint16_t playback_get_volume_mu16(pli_t queue);
int      playback_get_volume_mpc(pli_t queue);

struct roar_stream * playback_get_stream (pli_t queue);
struct rpld_playlist_entry * playback_get_ple (pli_t queue);
size_t playback_get_mduc(pli_t queue);

#endif

//ll
