/*  RipOff - Plugin based CD Ripper
 *  Copyright (C) 2006 Bobby Ryan Newberry
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include <stdio.h>
#include <stdlib.h>
#include "lib/RipOffPluginRawInterface.h"

void WriteWav(FILE *output_descriptor,long bytes);
static void PutNum(long num, FILE *output_descriptor, int endianness, int bytes);

RipOffPluginRaw ripoff_plugin_raw_new(xmlDocPtr ptr)
{
	RipOffPluginRaw raw = g_new(struct RipOffPluginRaw_, 1);
	ripoff_config_file_set_config_file_pointer(ptr);
	raw->name = "Wav Plugin v1.1";
	raw->label = "ripoff_default_wav_plugin";
	
	/* this function should take care of the stored preferences loading */
	return raw;
}

gchar *ripoff_plugin_raw_get_name(RipOffPluginRaw raw)
{
	return raw->name;
}

gchar *ripoff_plugin_raw_get_label(RipOffPluginRaw raw)
{
	return raw->label;
}

const gchar *ripoff_plugin_raw_get_extension(RipOffPluginRaw raw)
{
	return "wav";
}

gboolean ripoff_plugin_raw_has_prefs(RipOffPluginRaw raw)
{
	return FALSE;
}

GtkWidget *ripoff_plugin_raw_prefs(RipOffPluginRaw raw/*, GtkWidget *pref_window*/)
{
	return NULL;
}

gboolean ripoff_plugin_raw_has_about(RipOffPluginRaw raw)
{
	return TRUE;
}

GtkWidget *ripoff_plugin_raw_about(RipOffPluginRaw raw)
{
	return about_window_draw(	        "Wav Plugin", 
						"Wav Plugin 1.1", 
						"Wav Output Plugin for RipOff",
						"Copyright © "YEAR" Bobby Ryan Newberry",
						WEBSITE);
}

gboolean ripoff_plugin_raw_perform_setup(	RipOffPluginRaw raw,
						long total_bytes_to_encode,
						FILE *output_descriptor,
						RipOffTrack track)
{
	WriteWav(output_descriptor, total_bytes_to_encode);
}

gboolean ripoff_plugin_raw_encode_buffer(	RipOffPluginRaw raw,
						long total_bytes_to_encode,
						int16_t *audio_data,
						FILE *output_descriptor,
						RipOffTrack track)
{
	fwrite(((char *)audio_data),  CDIO_CD_FRAMESIZE_RAW, 1, output_descriptor);
}

gboolean ripoff_plugin_raw_perform_cleanup(	RipOffPluginRaw raw,
						long total_bytes_to_encode,
						FILE *output_descriptor,
						RipOffTrack track)
{
	return TRUE;
}

void ripoff_plugin_raw_close(RipOffPluginRaw raw)
{
}

void WriteWav(FILE *output_descriptor,long bytes)
{
  /* quick and dirty */

  fwrite("RIFF", 4, 1, output_descriptor);               /*  0-3 */
  PutNum(bytes+44-8,output_descriptor,0,4);        /*  4-7 */
  fwrite("WAVEfmt ", 8, 1,output_descriptor);           /*  8-15 */
  PutNum(16,output_descriptor,0,4);                /* 16-19 */
  PutNum(1,output_descriptor,0,2);                 /* 20-21 */
  PutNum(2,output_descriptor,0,2);                 /* 22-23 */
  PutNum(44100,output_descriptor,0,4);             /* 24-27 */
  PutNum(44100*2*2,output_descriptor,0,4);         /* 28-31 */
  PutNum(4,output_descriptor,0,2);                 /* 32-33 */
  PutNum(16,output_descriptor,0,2);                /* 34-35 */
  fwrite("data", 4, 1, output_descriptor);               /* 36-39 */
  PutNum(bytes,output_descriptor,0,4);             /* 40-43 */
}

static void PutNum(long num, FILE *output_descriptor, int endianness, int bytes)
{
  int i;
  unsigned char c;

  if(!endianness)
    i=0;
  else
    i=bytes-1;
  while(bytes--){
    c=(num>>(i<<3))&0xff;
    if(fwrite(&c, 1, 1, output_descriptor)==-1){
      perror("Could not write to output.");
      exit(1);
    }
    if(endianness)
      i--;
    else
      i++;
  }
}
