#include "RGtk.h"

/**
 Return the list of child widgets for the given container.
 */
USER_OBJECT_
R_gtkGetChildren(USER_OBJECT_ scontainer)
{
   GtkWidget *parent, *w;
   GList *els;
   int i, n;
   USER_OBJECT_ ans;

   parent = (GtkWidget*) getPtrValue(scontainer);  
   els = gtk_container_children(GTK_CONTAINER(parent));
   
   n = g_list_length(els);
   PROTECT(ans = NEW_LIST(n));
   for(i = 0; i < n; i++) {
     w = (GtkWidget*) g_list_nth_data(els, i);
     SET_VECTOR_ELT(ans, i, R_gtkWidgetReference(w,"GtkObject"));
   }
   UNPROTECT(1);
   return(ans);
}


/**
  Return the widget object 
*/
USER_OBJECT_
R_gtkGetParent(USER_OBJECT_ swidget)
{
   GtkWidget *w, *p;
   w = (GtkWidget*) getPtrValue(swidget);  
   p = gtk_widget_get_ancestor(w, GTK_TYPE_OBJECT);
   if(p == w)
       return(NULL_USER_OBJECT);
   return(R_gtkWidgetReference(w, "GtkObject"));
}
