gdkVisualGetBestDepth <-
function(.flush = TRUE)
{

	 w <- .GtkCall("S_gdk_visual_get_best_depth", PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gdkImageGetPixel <-
function(image = NULL, x, y, .flush = TRUE)
{
	 gtkCheckInherits(image, "GdkImage")
	 x <- as.integer(x)
	 y <- as.integer(y)

	 w <- .GtkCall("S_gdk_image_get_pixel", image, x, y, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gdkColormapGetSystem <-
function(.flush = TRUE)
{

	 w <- .GtkCall("S_gdk_colormap_get_system", PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gdkVisualGetSystem <-
function(.flush = TRUE)
{

	 w <- .GtkCall("S_gdk_visual_get_system", PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gdkWindowHide <-
function(window = NULL, .flush = TRUE)
{
	 gtkCheckInherits(window, "GdkWindow")

	 w <- .GtkCall("S_gdk_window_hide", window, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gdkWindowSetCursor <-
function(win = NULL, cursor = NULL, .flush = TRUE)
{
	 gtkCheckInherits(win, "GdkWindow")
	 gtkCheckInherits(cursor, "GdkCursor")

	 w <- .GtkCall("S_gdk_window_set_cursor", win, cursor, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gdkFontId <-
function(font = NULL, .flush = TRUE)
{
	 gtkCheckInherits(font, "GdkFont")

	 w <- .GtkCall("S_gdk_font_id", font, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gdkRegionRectIn <-
function(region = NULL, rect = NULL, .flush = TRUE)
{
	 gtkCheckInherits(region, "GdkRegion")
	 gtkCheckInherits(rect, "GdkRectangle")

	 w <- .GtkCall("S_gdk_region_rect_in", region, rect, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gdkRegionNew <-
function(.flush = TRUE)
{

	 w <- .GtkCall("S_gdk_region_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GdkRegion")
	 return(w)

}
 

gdkRegionPointIn <-
function(region = NULL, x, y, .flush = TRUE)
{
	 gtkCheckInherits(region, "GdkRegion")
	 x <- as.integer(x)
	 y <- as.integer(y)

	 w <- .GtkCall("S_gdk_region_point_in", region, x, y, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gdkRegionUnionWithRect <-
function(region = NULL, rect = NULL, .flush = TRUE)
{
	 gtkCheckInherits(region, "GdkRegion")
	 gtkCheckInherits(rect, "GdkRectangle")

	 w <- .GtkCall("S_gdk_region_union_with_rect", region, rect, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gdkRegionShrink <-
function(region = NULL, dx, dy, .flush = TRUE)
{
	 gtkCheckInherits(region, "GdkRegion")
	 dx <- as.integer(dx)
	 dy <- as.integer(dy)

	 w <- .GtkCall("S_gdk_region_shrink", region, dx, dy, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gdkPixmapNew <-
function(window = NULL, width, height, depth, .flush = TRUE)
{
	 gtkCheckInherits(window, "GdkWindow")
	 width <- as.integer(width)
	 height <- as.integer(height)
	 depth <- as.integer(depth)

	 w <- .GtkCall("S_gdk_pixmap_new", window, width, height, depth, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GdkPixmap")
	 return(w)

}
 

gdkColormapAllocColor <-
function(colormap = NULL, color, writable = false, best.match = true, .flush = TRUE)
{
	 gtkCheckInherits(colormap, "GdkColormap")
	 gtkCheckInherits(color, "GdkColor")
	 writable <- as.logical(writable)
	 best.match <- as.logical(best.match)

	 w <- .GtkCall("S_gdk_colormap_alloc_color", colormap, color, writable, best.match, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gdkColormapNew <-
function(visual = NULL, allocate, .flush = TRUE)
{
	 gtkCheckInherits(visual, "GdkVisual")
	 allocate <- as.integer(allocate)

	 w <- .GtkCall("S_gdk_colormap_new", visual, allocate, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GdkColormap")
	 return(w)

}
 

gdkRectangleUnion <-
function(src1 = NULL, src2 = NULL, dest = NULL, .flush = TRUE)
{
	 gtkCheckInherits(src1, "GdkRectangle")
	 gtkCheckInherits(src2, "GdkRectangle")
	 gtkCheckInherits(dest, "GdkRectangle")

	 w <- .GtkCall("S_gdk_rectangle_union", src1, src2, dest, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gdkWindowShow <-
function(window = NULL, .flush = TRUE)
{
	 gtkCheckInherits(window, "GdkWindow")

	 w <- .GtkCall("S_gdk_window_show", window, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gdkImageNew <-
function(type = GdkImageType[1], visual = NULL, width, height, .flush = TRUE)
{
	 type  <- mapGdkImageType(type)
	 gtkCheckInherits(visual, "GdkVisual")
	 width <- as.integer(width)
	 height <- as.integer(height)

	 w <- .GtkCall("S_gdk_image_new", type, visual, width, height, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GdkImage")
	 return(w)

}
 

gdkColormapGetVisual <-
function(colormap = NULL, .flush = TRUE)
{
	 gtkCheckInherits(colormap, "GdkColormap")

	 w <- .GtkCall("S_gdk_colormap_get_visual", colormap, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gdkRegionOffset <-
function(region = NULL, dx, dy, .flush = TRUE)
{
	 gtkCheckInherits(region, "GdkRegion")
	 dx <- as.integer(dx)
	 dy <- as.integer(dy)

	 w <- .GtkCall("S_gdk_region_offset", region, dx, dy, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gdkWindowNew <-
function(parent = NULL, attributes = NULL, attributes.mask, .flush = TRUE)
{
	 gtkCheckInherits(parent, "GdkWindow")
	 gtkCheckInherits(attributes, "GdkWindowAttr")
	 attributes.mask <- as.integer(attributes.mask)

	 w <- .GtkCall("S_gdk_window_new", parent, attributes, attributes.mask, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GdkWindow")
	 return(w)

}
 

gdkImageGet <-
function(window = NULL, x, y, width, height, .flush = TRUE)
{
	 gtkCheckInherits(window, "GdkWindow")
	 x <- as.integer(x)
	 y <- as.integer(y)
	 width <- as.integer(width)
	 height <- as.integer(height)

	 w <- .GtkCall("S_gdk_image_get", window, x, y, width, height, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gdkWindowClearAreaE <-
function(window = NULL, x, y, width, height, .flush = TRUE)
{
	 gtkCheckInherits(window, "GdkWindow")
	 x <- as.integer(x)
	 y <- as.integer(y)
	 width <- as.integer(width)
	 height <- as.integer(height)

	 w <- .GtkCall("S_gdk_window_clear_area_e", window, x, y, width, height, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gdkVisualGetBestType <-
function(.flush = TRUE)
{

	 w <- .GtkCall("S_gdk_visual_get_best_type", PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gdkFontEqual <-
function(fonta = NULL, fontb = NULL, .flush = TRUE)
{
	 gtkCheckInherits(fonta, "GdkFont")
	 gtkCheckInherits(fontb, "GdkFont")

	 w <- .GtkCall("S_gdk_font_equal", fonta, fontb, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gdkWindowClearArea <-
function(window = NULL, x, y, width, height, .flush = TRUE)
{
	 gtkCheckInherits(window, "GdkWindow")
	 x <- as.integer(x)
	 y <- as.integer(y)
	 width <- as.integer(width)
	 height <- as.integer(height)

	 w <- .GtkCall("S_gdk_window_clear_area", window, x, y, width, height, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gdkRegionEmpty <-
function(region = NULL, .flush = TRUE)
{
	 gtkCheckInherits(region, "GdkRegion")

	 w <- .GtkCall("S_gdk_region_empty", region, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gdkWindowGetParent <-
function(window = NULL, .flush = TRUE)
{
	 gtkCheckInherits(window, "GdkWindow")

	 w <- .GtkCall("S_gdk_window_get_parent", window, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gdkImagePutPixel <-
function(image = NULL, x, y, pixel, .flush = TRUE)
{
	 gtkCheckInherits(image, "GdkImage")
	 x <- as.integer(x)
	 y <- as.integer(y)
	 pixel <- as.integer(pixel)

	 w <- .GtkCall("S_gdk_image_put_pixel", image, x, y, pixel, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gdkColormapGetSystemSize <-
function(.flush = TRUE)
{

	 w <- .GtkCall("S_gdk_colormap_get_system_size", PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gdkRegionEqual <-
function(region1 = NULL, region2 = NULL, .flush = TRUE)
{
	 gtkCheckInherits(region1, "GdkRegion")
	 gtkCheckInherits(region2, "GdkRegion")

	 w <- .GtkCall("S_gdk_region_equal", region1, region2, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gdkRectangleIntersect <-
function(src1 = NULL, src2 = NULL, dest = NULL, .flush = TRUE)
{
	 gtkCheckInherits(src1, "GdkRectangle")
	 gtkCheckInherits(src2, "GdkRectangle")
	 gtkCheckInherits(dest, "GdkRectangle")

	 w <- .GtkCall("S_gdk_rectangle_intersect", src1, src2, dest, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

