#include "rcui.h"

static void varw_add_columns (GtkTreeView *treeview, gchar type)
{
	GtkCellRenderer *renderer;
	GtkTreeViewColumn *column;

  renderer = gtk_cell_renderer_text_new ();
  column = gtk_tree_view_column_new_with_attributes (_("Name"),
                                                   renderer,
                                                   "text", RCUI_VARW_NAME_COLUMN,
                                                   NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);
  
  renderer = gtk_cell_renderer_text_new ();
  if (type == RCUI_VARW_FUNCLIST)
    column = gtk_tree_view_column_new_with_attributes (_("Expression"),
                                                   renderer,
                                                   "text", RCUI_VARW_SECOND_COLUMN,
                                                   NULL);
  else
      column = gtk_tree_view_column_new_with_attributes (_("Value"),
                                                   renderer,
                                                   "text", RCUI_VARW_SECOND_COLUMN,
                                                   NULL);
    
  gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);

}

GtkWidget*
create_var_window (GtkWindow *main_window)
{
  GtkWidget *var_window;
  GtkWidget *varw_notebook;
  GtkWidget *varw_myv_scrolledw;
  GtkWidget *varw_myv_treeview;
  GtkWidget *varw_myvar_lbl;
  GtkWidget *varw_myf_scrolledw;
  GtkWidget *varw_myf_treeview;
  GtkWidget *varw_myf_lbl;
  GtkWidget *varw_biv_scrolledw;
  GtkWidget *varw_biv_treeview;
  GtkWidget *varw_builtin_lbl;
  GtkWidget *varw_bif_scrolledw;
  GtkWidget *varw_bif_treeview;
  GtkWidget *varw_biff_lbl;

  var_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_size_request (var_window, -1, 370);
  gtk_window_set_title (GTK_WINDOW (var_window), _("rcalc : Variables"));

  gtk_window_set_transient_for ( GTK_WINDOW (var_window), main_window );

  varw_notebook = gtk_notebook_new ();
  gtk_widget_show (varw_notebook);
  gtk_container_add (GTK_CONTAINER (var_window), varw_notebook);

  varw_myv_scrolledw = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (varw_myv_scrolledw);
  gtk_container_add (GTK_CONTAINER (varw_notebook), varw_myv_scrolledw);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (varw_myv_scrolledw), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (varw_myv_scrolledw), GTK_SHADOW_IN);

/*  varw_myv_treeview = gtk_tree_view_new ();
  gtk_widget_show (varw_myv_treeview);
  gtk_container_add (GTK_CONTAINER (varw_myv_scrolledw), varw_myv_treeview);
*/
/* ****** */
  varw_myv_treeview = gtk_tree_view_new_with_model (GTK_TREE_MODEL (ui_stores.varw_myv_store));
  gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (varw_myv_treeview), TRUE);
  gtk_widget_show (varw_myv_treeview);
  gtk_container_add (GTK_CONTAINER (varw_myv_scrolledw), varw_myv_treeview);
  /*gtk_widget_set_size_request (varw_myv_treeview, -1, 360);*/
  
  varw_add_columns(GTK_TREE_VIEW(varw_myv_treeview), RCUI_VARW_VARLIST);
/* ****** */


  varw_myvar_lbl = gtk_label_new (_("My variables"));
  gtk_widget_show (varw_myvar_lbl);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (varw_notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (varw_notebook), 0), varw_myvar_lbl);

  varw_myf_scrolledw = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (varw_myf_scrolledw);
  gtk_container_add (GTK_CONTAINER (varw_notebook), varw_myf_scrolledw);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (varw_myf_scrolledw), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (varw_myf_scrolledw), GTK_SHADOW_IN);

/*  varw_myf_treeview = gtk_tree_view_new ();
  gtk_widget_show (varw_myf_treeview);
  gtk_container_add (GTK_CONTAINER (varw_myf_scrolledw), varw_myf_treeview);
*/
/* ****** */
  varw_myf_treeview = gtk_tree_view_new_with_model (GTK_TREE_MODEL (ui_stores.varw_myf_store));
  gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (varw_myf_treeview), TRUE);
  gtk_widget_show (varw_myf_treeview);
  gtk_container_add (GTK_CONTAINER (varw_myf_scrolledw), varw_myf_treeview);
  /*gtk_widget_set_size_request (varw_myv_treeview, -1, 360);*/
  
  varw_add_columns(GTK_TREE_VIEW(varw_myf_treeview), RCUI_VARW_FUNCLIST);
/* ****** */
  varw_myf_lbl = gtk_label_new (_("My functions"));
  gtk_widget_show (varw_myf_lbl);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (varw_notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (varw_notebook), 1), varw_myf_lbl);

  varw_biv_scrolledw = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (varw_biv_scrolledw);
  gtk_container_add (GTK_CONTAINER (varw_notebook), varw_biv_scrolledw);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (varw_biv_scrolledw), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (varw_biv_scrolledw), GTK_SHADOW_IN);

/*  varw_biv_treeview = gtk_tree_view_new ();
  gtk_widget_show (varw_biv_treeview);
  gtk_container_add (GTK_CONTAINER (varw_biv_scrolledw), varw_biv_treeview);
*/
/* ****** */
  varw_biv_treeview = gtk_tree_view_new_with_model (GTK_TREE_MODEL (ui_stores.varw_biv_store));
  gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (varw_biv_treeview), TRUE);
  gtk_widget_show (varw_biv_treeview);
  gtk_container_add (GTK_CONTAINER (varw_biv_scrolledw), varw_biv_treeview);
  /*gtk_widget_set_size_request (varw_myv_treeview, -1, 360);*/
  
  varw_add_columns(GTK_TREE_VIEW(varw_biv_treeview), RCUI_VARW_VARLIST);
/* ****** */
  varw_builtin_lbl = gtk_label_new (_("Constants"));
  gtk_widget_show (varw_builtin_lbl);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (varw_notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (varw_notebook), 2), varw_builtin_lbl);

  varw_bif_scrolledw = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (varw_bif_scrolledw);
  gtk_container_add (GTK_CONTAINER (varw_notebook), varw_bif_scrolledw);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (varw_bif_scrolledw), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (varw_bif_scrolledw), GTK_SHADOW_IN);

/*  varw_bif_treeview = gtk_tree_view_new ();
  gtk_widget_show (varw_bif_treeview);
  gtk_container_add (GTK_CONTAINER (varw_bif_scrolledw), varw_bif_treeview);
*/
/* ****** */
  varw_bif_treeview = gtk_tree_view_new_with_model (GTK_TREE_MODEL (ui_stores.varw_bif_store));
  gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (varw_bif_treeview), TRUE);
  gtk_widget_show (varw_bif_treeview);
  gtk_container_add (GTK_CONTAINER (varw_bif_scrolledw), varw_bif_treeview);
  /*gtk_widget_set_size_request (varw_myv_treeview, -1, 360);*/
  
  varw_add_columns(GTK_TREE_VIEW(varw_bif_treeview), RCUI_VARW_FUNCLIST);
/* ****** */
  varw_biff_lbl = gtk_label_new (_("Built-in functions"));
  gtk_widget_show (varw_biff_lbl);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (varw_notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (varw_notebook), 3), varw_biff_lbl);

  g_signal_connect ((gpointer) var_window, "destroy",
                            G_CALLBACK (on_var_window_destroy),
                            GTK_OBJECT (var_window));

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (var_window, var_window, "var_window");
  GLADE_HOOKUP_OBJECT (var_window, varw_notebook, "varw_notebook");
  GLADE_HOOKUP_OBJECT (var_window, varw_myv_scrolledw, "varw_myv_scrolledw");
  GLADE_HOOKUP_OBJECT (var_window, varw_myv_treeview, "varw_myv_treeview");
  GLADE_HOOKUP_OBJECT (var_window, varw_myvar_lbl, "varw_myvar_lbl");
  GLADE_HOOKUP_OBJECT (var_window, varw_myf_scrolledw, "varw_myf_scrolledw");
  GLADE_HOOKUP_OBJECT (var_window, varw_myf_treeview, "varw_myf_treeview");
  GLADE_HOOKUP_OBJECT (var_window, varw_myf_lbl, "varw_myf_lbl");
  GLADE_HOOKUP_OBJECT (var_window, varw_biv_scrolledw, "varw_biv_scrolledw");
  GLADE_HOOKUP_OBJECT (var_window, varw_biv_treeview, "varw_biv_treeview");
  GLADE_HOOKUP_OBJECT (var_window, varw_builtin_lbl, "varw_builtin_lbl");
  GLADE_HOOKUP_OBJECT (var_window, varw_bif_scrolledw, "varw_bif_scrolledw");
  GLADE_HOOKUP_OBJECT (var_window, varw_bif_treeview, "varw_bif_treeview");
  GLADE_HOOKUP_OBJECT (var_window, varw_biff_lbl, "varw_biff_lbl");

  return var_window;
}
