/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <config.h>
#include <string.h>

#include <glib.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>

#include <engine/engine.h>
#include "engine/engine-private.h"

#include "exec.h"

extern RcEngine *RC_engine;

void
rca_exec_command (MCData     *mc,
		 const char *cmd)
{
  gchar *expr;
  gchar *genexpr;
  RcLastRes RC_result;

  expr = g_convert (cmd, -1, "ASCII", "UTF-8", NULL, NULL, NULL);
  if (!expr) {
    g_print("Error: could not convert input to ASCII\n");
    gtk_entry_set_text (GTK_ENTRY (mc->entry), "Error: could not convert input to ASCII");
    return;
  }
    
  rc_engine_execute( RC_engine, expr );
  RC_result = rc_import_lastres();
  
  if ( RC_result.expType == RC_EXP_VALUE )
  {
    GtkTreeIter iter;
    
    gtk_entry_set_text (GTK_ENTRY (mc->entry), RC_result.value);
    gtk_editable_set_position (GTK_EDITABLE(mc->entry),0);
    
    gtk_list_store_prepend (mc->history, &iter);
  
    gtk_list_store_set (mc->history, &iter, 0, expr, -1);
  }
  
  g_free(expr);
}

