--
-- Copyright (C) 2003 by Troll Phone Networks AS
--
-- This program is distributed under the terms of the GNU General Public License
-- as published by the Free Software Foundation; either version 2, or (at your
-- option) any later version.
--
--	$Id: schema.sql,v 1.8 2004/01/22 15:04:02 tholo Exp $
--

--
-- Table structure for table 'cdr'
--

DROP TABLE IF EXISTS cdr;
CREATE TABLE cdr (
  callDate datetime NOT NULL default '0000-00-00 00:00:00',	-- Date and time the call started
  endDate datetime NOT NULL default '0000-00-00 00:00:00',	-- Date and time the call ended
  ANI char(80) NOT NULL default '',			-- Calling party ANI
  callerID char(80) default NULL,			-- Calling party Caller*ID
  calledNumber char(80) NOT NULL default '',		-- Called number
  calledContext char(80) NOT NULL default '',		-- Called context
  sourceChannel char(80) NOT NULL default '',		-- Source channel for call
  destinationChannel char(80) NOT NULL default '',	-- Called channel for call
  lastApplication char(80) NOT NULL default '',		-- Last application called
  lastData char(80) default NULL,			-- Arguments to last application
  callDuration int(10) unsigned NOT NULL default '0',	-- Total length of call
  billableDuration int(10) unsigned NOT NULL default '0',	-- Billable length of call;
							--  starts when call is ANSWERED,
							--  will be rounded up to nearest
							--  higher ``periods'' from rate
							--  table
  callDisposition char(16) default NULL,		-- Call disposition -- ANSWERED,
							--  BUSY, NO ANSWER etc.
  amaFlags char(16) default NULL,			-- How CDR should be processed --
							--  DOCUMENTATION, BILLING etc.
  accountCode char(20) default NULL,			-- Account code for call
  destinationDescription char(80) default NULL,		-- Description of destination
							--  called -- may be used in billing
  callCost decimal(12,4) default NULL,			-- Calculated cost of call
  uniqueID char(32) NOT NULL default '',		-- Unique Call ID
  handlingSystem char(32) default NULL			-- System handling the call
) TYPE=MyISAM;

--
-- Table structure for table 'egress'
--

DROP TABLE IF EXISTS egress;
CREATE TABLE egress (
  route_id int(10) unsigned NOT NULL auto_increment,	-- Unique ID for this egress route
  provider_id int(10) unsigned NOT NULL default '0',	-- Should match a provider
  technology varchar(16) NOT NULL default '',		-- Technology for egress route, e.g.
							--  IAX, IAX2, SIP etc.
  peer varchar(32) NOT NULL default '',			-- Peer for this egress route, e.g.
							--  iaxtel, sip.example.com
  pattern varchar(80) NOT NULL default '',		-- Pattern to match in input phone
							--  number, typically "(.*)"
  substitute varchar(80) NOT NULL default '',		-- Rewrite pattern for phone number,
							--  might be e.g. "IAX2/peer/9011$1"
							--  to just prefix the number with
							--  "9011" and use IAX2/peer to
							--  place the call
  description varchar(80) default NULL,			-- Description of egress route
  PRIMARY KEY  (route_id),
  KEY provider_id (provider_id)
) TYPE=MyISAM;

--
-- Table structure for table 'provider'
--

DROP TABLE IF EXISTS provider;
CREATE TABLE provider (
  provider_id int(10) unsigned NOT NULL auto_increment,	-- Unique ID for this provider
  name varchar(80) NOT NULL default '',			-- Name of provider
  PRIMARY KEY  (provider_id)
) TYPE=MyISAM;

--
-- Table structure for table 'rate'
--

DROP TABLE IF EXISTS rate;
CREATE TABLE rate (
  rate_id int(10) unsigned NOT NULL auto_increment,	-- Unique ID for this rate
  route_id int(10) unsigned NOT NULL default '0',	-- Should match an egress route!
  iso char(2) NOT NULL default '',			-- ISO country code
  type char(3) default NULL,				-- Type of destination
  country varchar(40) NOT NULL default '',		-- Textual description of
							--  destination country
  extra varchar(40) default NULL,			-- Additional textual description
							--  (e.g. cell, geographic location)
  prefix varchar(10) NOT NULL default '',		-- What number prefix this rate
							--  is for
  active_date date default NULL,			-- At what time this rate becomes
							--  valid
  expires_date date default NULL,			-- At what time this rate stops
							--  being valid
  firstperiod int(10) unsigned NOT NULL default '0',	-- Length of first call period, in
							--  seconds (can be, and often is, 0)
  periods int(10) unsigned NOT NULL default '0',	-- Length of remaining call periods,
							--  in seconds (typically 60)
  startcost int(10) unsigned NOT NULL default '0',	-- Cost of an answered call,
							--  including first period; this is
							--  charged as soon as the phone has
							--  been ANSWERED
  periodcost int(10) unsigned NOT NULL default '0',	-- Cost of each period, excluding first
							--  call period (if non-0 above)
  trialcost int(10) unsigned NOT NULL default '0',	-- Cost of a failed call attempt,
							--  most often (but not always) 0
  PRIMARY KEY  (rate_id),
  KEY route_id (route_id),
  KEY prefix (prefix)
) TYPE=MyISAM;

