/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: scache.c,v 1.9.2.1 2004/12/07 03:05:40 pneumatus Exp $
 */

#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "h.h"
#include "memory.h"

static ServerCache *server_cache[SCACHE_HASH_SIZE];

void clear_scache_hash_table()
{
	memset(server_cache, '\0', SCACHE_HASH_SIZE);
}

static int serv_hash(char *str)
{
	int sindex = 0;

	while (*str != '\0') {
		sindex += ToLower(*str++);
	}

	return (sindex % SCACHE_HASH_SIZE);
}

char *find_or_add(char *name)
{
	int sindex = serv_hash(name);
	ServerCache *serv;

	for (serv = server_cache[sindex]; serv != NULL; serv = serv->next) {
		if (!irccmp(serv->name, name)) {
			return serv->name;
		}
	}

	serv = (ServerCache *)MyMalloc(sizeof(ServerCache));
	strncpyzt(serv->name, name, HOSTLEN + 1);
	serv->next = server_cache[sindex];
	server_cache[sindex] = serv;

	return serv->name;
}

void count_scache_memory(int *scache_cnt, unsigned long *scache_mem)
{
	ServerCache *serv = NULL;
	int sindex, cnt = 0;
	unsigned long mem = 0;

	for (sindex = 0; sindex < SCACHE_HASH_SIZE; sindex++) {
		for (serv = server_cache[sindex]; serv != NULL; serv = serv->next) {
			cnt++;
			mem += strlen(serv->name);
		}
	}

	mem += (cnt * sizeof(ServerCache));

	*scache_cnt = cnt;
	*scache_mem = mem;
}

void list_scache(aClient *cptr)
{
	ServerCache *serv;
	int sindex;

	for (sindex = 0; sindex < SCACHE_HASH_SIZE; sindex++) {
		for (serv = server_cache[sindex]; serv != NULL; serv = serv->next) {
			ASSERT(!BadPtr(serv->name));
			send_me_debug(cptr, "S :%s", serv->name);
		}
	}
}
