/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_watch.c,v 1.23.2.2 2005/01/15 23:53:30 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include "xmode.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

static char buf[BUFSIZE];

Module MOD_HEADER(m_watch) = {
	"m_watch",
	"/WATCH command",
	6, "$Revision: 1.23.2.2 $"
};

int MOD_LOAD(m_watch)()
{
	if (register_command(&MOD_HEADER(m_watch), &CMD_WATCH, m_watch) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_watch)()
{
	return MOD_SUCCESS;
}

static void show_watch(aClient *sptr, char *name, int rpl1, int rpl2)
{
	aClient *acptr = NULL;
	if ((acptr = find_person(name, NULL)) != NULL) {
		send_me_numeric(sptr, rpl1, acptr->name, acptr->username, MaskedHost(acptr),
			acptr->lasttime);
	}
	else {
		send_me_numeric(sptr, rpl2, name, "*", "*", 0);
	}
	return;
}

/*
 * m_watch
 *	parv[0] = sender prefix
 *	parv[1] = parameter
 */
int m_watch(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	aClient *acptr;
	char *s, *p = NULL, def[2] = "l";

	if (parc < 2) {
		parc = 2;
		parv[1] = def;
	}

	for (s = strtoken(&p, parv[1], ", "); s != NULL; s = strtoken(&p, NULL, ", ")) {
		if (*s == '+') {
			if (*(s + 1) != '\0') {
				if (sptr->user->watches >= GeneralConfig.max_watch) {
					send_me_numeric(sptr, ERR_TOOMANYWATCH, (s + 1), GeneralConfig.max_watch);
					continue;
				}
				add_to_watch_hash_table(s + 1, sptr);
			}
			show_watch(sptr, s + 1, RPL_NOWON, RPL_NOWOFF);
			continue;
		}
		if (*s == '-') {
			del_from_watch_hash_table(s + 1, sptr);
			show_watch(sptr, s + 1, RPL_WATCHOFF, RPL_WATCHOFF);
			continue;
		}
		if (*s == 'c' || *s == 'C') {
			hash_del_watch_list(sptr);
			continue;
		}
		if (*s == 's' || *s == 'S') {
			SLink *lp;
			aWatch *anptr;
			int count = 0;

			if ((anptr = hash_get_watch(sptr->name)) != NULL) {
				for (lp = anptr->watch; lp != NULL; lp = lp->next) {
					count++;
				}
			}
			send_me_numeric(sptr, RPL_WATCHSTAT, sptr->user->watches, count);

			*buf = '\0';
			if ((lp = sptr->user->watch) == NULL) {
				send_me_numeric(sptr, RPL_ENDOFWATCHLIST, *s);
				continue;
			}

			strcpy(buf, lp->value.wptr->nick);
			count = strlen(parv[0]) + strlen(me.name) + strlen(buf) + 10;
			while (lp != NULL) {
				if (count + strlen(lp->value.wptr->nick) + 1 > BUFSIZE - 2) {
					send_me_numeric(sptr, RPL_WATCHLIST, buf);
					*buf = '\0';
					count = strlen(parv[0]) + strlen(me.name) + 10;
				}
				strcat(buf, " ");
				strcat(buf, lp->value.wptr->nick);
				count += strlen(lp->value.wptr->nick) + 1;
				lp = lp->next;
			}

			send_me_numeric(sptr, RPL_WATCHLIST, buf);
			send_me_numeric(sptr, RPL_ENDOFWATCHLIST, *s);
			continue;
		}
		if (*s == 'l' || *s == 'L') {
			SLink *lp;
			for (lp = sptr->user->watch; lp != NULL; lp = lp->next) {
				if ((acptr = find_person(lp->value.wptr->nick, NULL)) != NULL) {
					send_me_numeric(sptr, RPL_NOWON, acptr->name, acptr->username,
						MaskedHost(acptr), acptr->tsinfo);
				}
				else if (IsUpper(*s)) {
					send_me_numeric(sptr, RPL_NOWOFF, lp->value.wptr->nick, "*",
						"*", lp->value.wptr->lasttime);
				}
			}
			send_me_numeric(sptr, RPL_ENDOFWATCHLIST, *s);
			continue;
		}
	}
	return 0;
}
