/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_userhost.c,v 1.20.2.2 2005/01/15 23:53:34 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include "xmode.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_userhost) = {
	"m_userhost",
	"/USERHOST command",
	6, "$Revision: 1.20.2.2 $"
};

int MOD_LOAD(m_userhost)()
{
	if (register_command(&MOD_HEADER(m_userhost), &CMD_USERHOST, m_userhost) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_userhost)()
{
	return MOD_SUCCESS;
}

/*
 * m_userhost
 *	parv[0] = sender prefix
 *	parv[1] = user
 */
int m_userhost(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	static char buf[BUFSIZE];
	char buf2[NICKLEN + USERLEN + HOSTLEN + 5];
	char *s, *p = NULL;
	aClient *acptr;
	int idx = 0, len, mlen, i = 5;

	if (parc < 2) {
		send_me_numeric(sptr, ERR_NEEDMOREPARAMS, "USERHOST");
		return 0;
	}

	mlen = strlen(me.name) + strlen(sptr->name) + 12;
	for (s = strtoken(&p, parv[1], " "); (i > 0) && (s != NULL); s = strtoken(&p, NULL, " ")) {
		i--;

		if ((acptr = find_person(s, NULL)) == NULL) {
			continue;
		}

		len = ircsprintf(buf2, "%s%s=%c%s@%s", acptr->name, HasMode(sptr, UMODE_OPER) ? "*" : "",
			BadPtr(acptr->user->away) ? '+' : '-', acptr->username, MaskedHost(acptr));

		if ((mlen + idx + len) > BUFSIZE - 1) {
			break;
		}
		ADD_STRING(buf2, buf, idx);
	}

	send_me_numeric(sptr, RPL_USERHOST, buf);
	return 0;
}
