/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_user.c,v 1.41.2.2 2005/01/15 23:53:33 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include "user_ban.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_user) = {
	"m_user",
	"/USER command",
	6, "$Revision: 1.41.2.2 $"
};

int MOD_LOAD(m_user)()
{
	if (register_command(&MOD_HEADER(m_user), &CMD_USER, m_user) == NULL) {
		return MOD_FAILURE;
	}
	MOD_SET_FLAG(&MOD_HEADER(m_user), MOD_FLAG_PERM);
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_user)()
{
	return MOD_SUCCESS;
}

/*
 * m_user
 *	parv[0] = sender prefix
 *	parv[1] = username
 *	parv[2] = client hostname (used only from other servers)
 *	parv[3] = server hostname (used only from other servers)
 *	parv[4] = users real name info
 */
int m_user(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	char *username, *host, *server, *realname;
	simBan *sban;

	if (sptr->localClient->listener != NULL) {
		if (sptr->localClient->listener->flags & LISTEN_SERVERONLY) {
			sendto_realops_lev(REJ_LEV, "Blocking unknown connection on server-only port %d",
				cptr->localClient->listener->port);
			return exit_client(cptr, sptr, sptr, "This port is for servers only");
		}
	}

	if (parc > 2 && (username = strchr(parv[1], '@')) != NULL) {
		*username = '\0';
	}
	if (parc < 5 || *parv[1] == '\0' || *parv[2] == '\0' || *parv[3] == '\0' || *parv[4] == '\0') {
		send_me_numeric(sptr, ERR_NEEDMOREPARAMS, "USER");
		if (IsServer(cptr)) {
			sendto_realops_lev(DEBUG_LEV, "Bad USER param count for %s from %s", parv[0],
				get_client_name(cptr, FALSE));
		}
		else {
			return 0;
		}
	}

	username = (parc < 2 || BadPtr(parv[1])) ? "<bad-boy>" : parv[1];
	host = (parc < 3 || BadPtr(parv[2])) ? "<nohost>" : parv[2];
	server = (parc < 4 || BadPtr(parv[3])) ? "<noserver>" : parv[3];
	realname = (parc < 5 || BadPtr(parv[4])) ? "<bad-realname>" : parv[4];

	if ((sban = find_simban_flags(realname, SBAN_GCOS)) != NULL) {
		send_me_numeric(cptr, ERR_YOUREBANNEDCREEP, "g-lined");
		return exit_client(cptr, sptr, sptr, BanReason(sban));
	}

	return do_user(parv[0], cptr, sptr, username, host, server, 0, 0, realname);
}
