/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_svskill.c,v 1.21.2.2 2005/01/15 23:53:32 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_svskill) = {
	"m_svskill",
	"/SVSKILL command",
	6, "$Revision: 1.21.2.2 $"
};

int MOD_LOAD(m_svskill)()
{
	if (register_command(&MOD_HEADER(m_svskill), &CMD_SVSKILL, m_svskill) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_svskill)()
{
	return MOD_SUCCESS;
}

/*
 * m_svskill
 *	parv[0] = sender prefix
 *	parv[1] = target
 *	parv[2] = target stamp
 *	parv[3] = message
 */
int m_svskill(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	aClient *acptr;
	char *comment, reason[TOPICLEN + 1];
	time_t ts = 0;

	if (!IsULine(sptr)) {
		return 0;
	}
	if (parc > 3) {
		comment = (*parv[3] != '\0') ? parv[3] : parv[0];
		ts = strtol(parv[2], NULL, 10);
	}
	else {
		comment = (parc > 2 && *parv[2] != '\0') ? parv[2] : parv[0];
	}

	if ((acptr = find_person_target(parv[1])) != NULL && (!ts || ts == acptr->tsinfo)) {
		if (MyClient(acptr)) {
			strcpy(reason, "SVSKilled: ");
			strncpy(reason + 11, comment, TOPICLEN - 11);
			reason[TOPICLEN] = '\0';
			ircdlog(LOG_KILL, "SVSKILL for %s by %s", get_client_name(acptr, FALSE),
				get_client_name(cptr, FALSE));
			exit_client(acptr, acptr, sptr, reason);
			return (acptr == cptr) ?  FLUSH_BUFFER : 0;
		}
		if (acptr->from == cptr) {
			sendto_realops_lev(DEBUG_LEV, "Received wrong-direction SVSKILL for %s (behined "
				"%s) from %s", acptr->name, cptr->name, get_client_name(sptr, HIDE_IP));
		}
		else if (ts && !CapID(acptr->from)) {
			sendto_one_client_nopostfix(acptr, sptr, &CMD_SVSKILL, "%s %ld :%s", parv[1],
				ts, comment);
		}
		else {
			sendto_one_client_real(acptr->from, acptr, sptr, &CMD_SVSKILL, ":%s", comment);
		}
	}
	return 0;
}
