/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_sqline.c,v 1.29.2.2 2005/01/15 23:53:32 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include "user_ban.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

extern char *collapse(char *);

Module MOD_HEADER(m_sqline) = {
	"m_sqline",
	"/SQLINE command",
	6, "$Revision: 1.29.2.2 $"
};

int MOD_LOAD(m_sqline)()
{
	if (register_command(&MOD_HEADER(m_sqline), &CMD_SQLINE, m_sqline) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_sqline)()
{
	return MOD_SUCCESS;
}

/*
 * m_sqline
 *	parv[0] = sender prefix
 *	parv[1] = nickname
 *	parv[2] = reason
 */
int m_sqline(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	simBan *sban;
	char *reason = (parc > 2 && !BadPtr(parv[1])) ? parv[2] : "Reserved";

	if (!(IsServer(sptr) || IsULine(sptr))) {
		return 0;
	}
	if (parc < 2) {
		return 0;
	}

	parv[1] = collapse(parv[1]);

	if ((sban = make_simban(parv[1], reason, 0, BAN_NETWORK|SBAN_NICK)) == NULL) {
		ircdlog(LOG_ERROR, "make_simban(%s,%s,0,0) failed in SQLINE", parv[1], reason);
		return 0;
	}

	if (find_simban_exact(sban) == NULL) {
		add_simban(sban);
	}
	else {
		simban_free(sban);
	}

	sendto_serv_msg_butone(cptr, sptr, &CMD_SQLINE, "%s :%s", parv[1], reason);
	return 0;
}
