/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_satopic.c,v 1.5.2.2 2005/01/15 23:53:32 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include "xmode.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_satopic) = {
	"m_satopic",
	"/SATOPIC command",
	6, "$Revision: 1.5.2.2 $"
};

int MOD_LOAD(m_satopic)()
{
	if (register_command(&MOD_HEADER(m_satopic), &CMD_SATOPIC, m_satopic) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_satopic)()
{
	return MOD_SUCCESS;
}

/*
 * m_satopic
 *	parv[0] = sender prefix
 *	parv[1] = channel
 *	parv[2] = topic
 */
int m_satopic(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	aChannel *chptr;

	if (!HasMode(sptr, UMODE_SADMIN)) {
		send_me_numericNA(sptr, ERR_NOPRIVILEGES);
		return 0;
	}
	if (parc < 3 || BadPtr(parv[2])) {
		send_me_numeric(sptr, ERR_NEEDMOREPARAMS, "SATOPIC");
		return 0;
	}
	if ((chptr = find_channel(parv[1], NULL)) == NULL) {
		send_me_numeric(sptr, ERR_NOSUCHCHANNEL, parv[1]);
		return 0;
	}

	strncpyzt(chptr->topic, parv[2], TOPICLEN + 1);
	strcpy(chptr->topic_nick, sptr->name);
	chptr->topic_time = timeofday;

	sendto_serv_msg_butone(NULL, &me, &CMD_TOPIC, "%s %s %lu :%s", chptr->chname,
		chptr->topic_nick, chptr->topic_time, chptr->topic);
	sendto_channel_local_msg_butone(NULL, &me, chptr, ALL_MEMBERS,
		&CMD_TOPIC, "%s :%s", chptr->chname, chptr->topic);

	sendto_realops("%s used SATOPIC %s (%s)", sptr->name, chptr->chname, chptr->topic);
	sendto_serv_msg_butone(NULL, &me, &CMD_GLOBOPS, ":%s used SATOPIC %s (%s)",
		sptr->name, chptr->chname, chptr->topic);
	ircdlog(LOG_OVERRIDE, "%s used SATOPIC %s (%s)", get_client_name(sptr, FALSE),
		chptr->chname, chptr->topic);

	return 0;
}
