/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_sakick.c,v 1.19.2.2 2005/01/15 23:53:34 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include "xmode.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_sakick) = {
	"m_sakick",
	"/SAKICK command",
	6, "$Revision: 1.19.2.2 $"
};

int MOD_LOAD(m_sakick)()
{
	if (register_command(&MOD_HEADER(m_sakick), &CMD_SAKICK, m_sakick) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_sakick)()
{
	return MOD_SUCCESS;
}

/*
 * m_sakick
 *	parv[0] = sender prefix
 *	parv[1] = channel
 *	parv[2] = user
 *	parv[3] = reason
 */
int m_sakick(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	aChannel *chptr;
	aClient *acptr;
	char *comment = (parc > 3 && !BadPtr(parv[3])) ? parv[3] : me.name, *p;

	if (!HasMode(sptr, UMODE_SADMIN)) {
		send_me_numericNA(sptr, ERR_NOPRIVILEGES);
		return 0;
	}
	if (parc < 3) {
		send_me_numeric(sptr, ERR_NEEDMOREPARAMS, "SAKICK");
		return 0;
	}

	if ((p = strchr(parv[1], ',')) != NULL) {
		*p = '\0';
	}
	if ((p = strchr(parv[2], ',')) != NULL) {
		*p = '\0';
	}

	if ((chptr = find_channel(parv[1], NULL)) == NULL) {
		send_me_numeric(sptr, ERR_NOSUCHCHANNEL, parv[1]);
		return 0;
	}
	if ((acptr = find_chasing(sptr, parv[2], NULL, MSG_SAKICK)) == NULL) {
		return 0;
	}

	if (!IsMember(acptr, chptr)) {
		if (MyClient(sptr)) {
			send_me_numeric(sptr, ERR_USERNOTINCHANNEL, chptr->chname, acptr->name);
		}
		return 0;
	}

	if (strlen(comment) > TOPICLEN) {
		comment[TOPICLEN] = '\0';
	}

	sendto_realops("%s used SAKICK %s %s (%s)", sptr->name, chptr->chname, acptr->name, comment);
	sendto_serv_msg_butone(NULL, &me, &CMD_GLOBOPS, ":%s used SAKICK %s %s (%s)", sptr->name,
		chptr->chname, acptr->name, comment);
	ircdlog(LOG_OVERRIDE, "%s used SAKICK %s %s (%s)", get_client_name(sptr, FALSE),
		chptr->chname, acptr->name, comment);

	sendto_channel_local_msg_butone(NULL, &me, chptr, ALL_MEMBERS, &CMD_KICK,
		"%s %s :%s", chptr->chname, acptr->name, comment);
	
	sendto_serv_capab_msg_butone(cptr, &me, NO_CAPS, ID_CAPS, &CMD_KICK, "%s %s :%s",
		chptr->chname, acptr->name, comment);
	sendto_serv_capab_msg_butone(cptr, &me, ID_CAPS, NO_CAPS, &CMD_KICK, "%s %s :%s",
		chptr->chname, get_id(acptr), comment);

	remove_user_from_channel(acptr, chptr);
	return 0;
}
