/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_rakill.c,v 1.23.2.2 2005/01/15 23:53:30 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include "user_ban.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_rakill) = {
	"m_rakill",
	"/RAKILL command",
	6, "$Revision: 1.23.2.2 $"
};

int MOD_LOAD(m_rakill)()
{
	if (register_command(&MOD_HEADER(m_rakill), &CMD_RAKILL, m_rakill) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_rakill)()
{
	return MOD_SUCCESS;
}

/*
 * m_rakill
 *	parv[0] = sender prefix
 *	parv[1] = host
 *	parv[2] = user
 */
int m_rakill(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	userBan *myban, *uban;

	if (!IsServer(sptr) || parc < 3) {
		return 0;
	}
	if (!IsULine(sptr)) {
		send_globops("Non-ULined server %s is trying to RAKILL!", parv[0]);
		sendto_serv_msg_butone(NULL, &me, &CMD_GLOBOPS, ":Non-ULined server %s is trying "
			"to RAKILL!", parv[0]);
		return 0;
	}

	if ((myban = make_userban(parv[2], parv[1], NULL, 0)) == NULL) {
		return 0;
	}

	myban->flags |= BAN_NETWORK;

	if ((uban = find_userban_exact(myban, BAN_NETWORK)) != NULL) {
		del_userban(uban);
		userban_free(uban);
	}

	userban_free(myban);

	sendto_serv_msg_butone(cptr, sptr, &CMD_RAKILL, "%s %s", parv[1], parv[2]);
	return 0;
}
