/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_pong.c,v 1.42.2.2 2005/01/15 23:53:32 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_pong) = {
	"m_pong",
	"/PONG command",
	6, "$Revision: 1.42.2.2 $"
};

int MOD_LOAD(m_pong)()
{
	if (register_command(&MOD_HEADER(m_pong), &CMD_PONG, m_pong) == NULL) {
		return MOD_FAILURE;
	}
	MOD_SET_FLAG(&MOD_HEADER(m_pong), MOD_FLAG_PERM);
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_pong)()
{
	return MOD_SUCCESS;
}

/*
 * m_pong
 *	parv[0] = sender prefix
 *	parv[1] = origin
 *	parv[2] = destination
 */
int m_pong(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	aClient *acptr = NULL;
	char *origin, *destination;

	if (parc < 2 || BadPtr(parv[1])) {
		send_me_numericNA(sptr, ERR_NOORIGIN);
		return 0;
	}

	origin = parv[1];
	destination = parv[2];

	ClearPingSent(cptr);
	ClearPingSent(sptr);

	if ((sptr == cptr) && IsServer(sptr)) {
		ASSERT(sptr->localClient != NULL);
		if (UserBurst(sptr)) {
			send_gnotice("%s has processed user/channel burst, sending topic burst.",
				sptr->name);

			ClearUserBurst(sptr);
			send_topic_burst(sptr);

			SetPingSent(sptr);
			SetSentSOB(sptr);

			sendto_one_client_nopostfix(sptr, &me, &CMD_PING, ":%s", me.name);
		}
		else if (TopicBurst(sptr)) {
			char *cap_list = get_synch_cap(sptr->localClient->capabs);

			ClearTopicBurst(sptr);

			send_gnotice("%s has processed topic burst, synch complete. (states: %s)",
				sptr->name, !BadPtr(cap_list) ? cap_list : "none");
			if (ServerInfo->hub) {
				sendto_serv_msg_butone(sptr, &me, &CMD_GNOTICE, ":%s has processed topic "
					"burst, synch complete. (states: %s)", sptr->name,
					!BadPtr(cap_list) ? cap_list : "none");
			}
			sendto_one_client_nopostfix(sptr, &me, &CMD_PING, ":%s", me.name);
		}
	}

	if (!BadPtr(destination) && mycmp(destination, me.name) && IsRegistered(sptr)) {
		if ((acptr = find_client(destination, NULL)) == NULL ||
		  (acptr = find_server(destination, NULL)) == NULL) {
			send_me_numeric(sptr, ERR_NOSUCHSERVER, destination);
			return 0;
		}
		sendto_one_client_nopostfix(acptr, sptr, &CMD_PONG, "%s %s", origin,
			destination);
	}
#ifdef DEBUGMODE
	else {
		Debug((DEBUG_NOTICE, "PONG: %s %s", origin, destination ? destination : "*"));
	}
#endif

	return 0;
}
