/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_part.c,v 1.37.2.2 2005/01/15 23:53:32 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include "xmode.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_part) = {
	"m_part",
	"/PART command",
	6, "$Revision: 1.37.2.2 $"
};

int MOD_LOAD(m_part)()
{
	if (register_command(&MOD_HEADER(m_part), &CMD_PART, m_part) == NULL) {
		return MOD_FAILURE;
	}
	MOD_SET_FLAG(&MOD_HEADER(m_part), MOD_FLAG_PERM);
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_part)()
{
	return MOD_SUCCESS;
}

/*
 * m_part
 *	parv[0] = sender prefix
 *	parv[1] = channel name
 *	parv[2] = message
 */
int m_part(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	aChannel *chptr;
	char *p, *name, *reason = ((parc > 2) && !BadPtr(parv[2])) ? parv[2] : NULL;
	int cant_send, parted = 0;

	if (parc < 2 || *parv[1] == '\0') {
		send_me_numeric(sptr, ERR_NEEDMOREPARAMS, "PART");
		return 0;
	}

	name = strtoken(&p, parv[1], ",");

	if (!BadPtr(name) && MyConnect(sptr) && !HasMode(sptr, UMODE_OPER)) {
		check_for_spambot(sptr, NULL);
	}

	while (name != NULL) {
		if ((chptr = get_channel(sptr, name, 0, NULL)) == NULL) {
			send_me_numeric(sptr, ERR_NOSUCHCHANNEL, name);
			name = strtoken(&p, NULL, ",");
			continue;
		}
		if (!IsMember(sptr, chptr)) {
			send_me_numeric(sptr, ERR_NOTONCHANNEL, name);
			name = strtoken(&p, NULL, ",");
			continue;
		}

		cant_send = 0;
		if (!IsULine(sptr) && MyClient(sptr)) {
			if ((cant_send = can_send(sptr, chptr, reason))) {
				msg_error(sptr, cant_send, chptr->chname);
			}
		}

		parted++;

		if ((reason == NULL) || cant_send) {
			sendto_serv_msg_butone(cptr, sptr, &CMD_PART, "%s", name);
			sendto_channel_local_msg_butone(NULL, sptr, chptr, ALL_MEMBERS,
				&CMD_PART, "%s", chptr->chname);
		}
		else {
			sendto_serv_msg_butone(cptr, sptr, &CMD_PART, "%s :%s", name, reason);
			sendto_channel_local_msg_butone(NULL, sptr, chptr, ALL_MEMBERS,
				&CMD_PART, "%s :%s", chptr->chname, reason);
		}

		remove_user_from_channel(sptr, chptr);
		name = strtoken(&p, NULL, ",");
	}

	if (MyClient(sptr) && parted) {
		sptr->localUser->last_part_time = timeofday;
	}

	return 0;
}
