/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_motd.c,v 1.29.2.2 2005/01/15 23:53:31 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include "xmode.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_motd) = {
	"m_motd",
	"/MOTD command",
	6, "$Revision: 1.29.2.2 $"
};

int MOD_LOAD(m_motd)()
{
	if (register_command(&MOD_HEADER(m_motd), &CMD_MOTD, m_motd) == NULL) {
		return MOD_FAILURE;
	} 
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_motd)()
{
	return MOD_SUCCESS;
}

/*
 * m_motd
 *	parv[0] = sender prefix
 *	parv[1] = server
 */
int m_motd(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	static time_t last_used = 0L;

	if (use_or_deliver(cptr, sptr, &CMD_MOTD, ":%s", 1, parc, parv) != HUNTED_ISME) {
		return 0;
	}
	if (!MyClient(sptr) && GeneralConfig.ignore_remote_motd) {
		return 0;
	}

	if (!HasMode(sptr, UMODE_OPER)) {
		if (FloodConfig.pace_wait_intense && (last_used + FloodConfig.pace_wait_intense > timeofday)) {
			send_me_numericNA(sptr, RPL_LOAD2HI);
			return 0;
		}
		else {
			last_used = timeofday;
		}
		if (GeneralConfig.spy_notices && IsPerson(sptr)) {
			sendto_realops_lev(SPY_LEV, "MOTD requested by %s (%s@%s) [%s]", sptr->name,
				sptr->username, MaskedHost(sptr), sptr->user->server);
		}
	}

	send_motd(sptr);
	return 0;
}
