/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_connect.c,v 1.39.2.2 2005/01/15 23:53:30 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include "xmode.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>  
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_connect) = {
	"m_connect",
	"/CONNECT command",
	6, "$Revision: 1.39.2.2 $"
};

int MOD_LOAD(m_connect)()
{
	if (register_command(&MOD_HEADER(m_connect), &CMD_CONNECT, m_connect) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_connect)()
{
	return MOD_SUCCESS;
}

/*
 * m_connect
 *	parv[0] = sender prefix
 *	parv[1] = servername
 *	parv[2] = port number
 *	parv[3] = remote server
 */
int m_connect(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	int port, tmpport;
	ConfigItem_link *linkp;
	aClient *acptr;
	char *inpath = NULL;

	if (MyClient(sptr)) {
		if (parc <= 3 && !OPHasFlag(sptr, OFLAG_LROUTE)) {
			send_me_numericNA(sptr, ERR_NOPRIVILEGES);
			return 0;
		}
		if (parc > 3 && !OPHasFlag(sptr, OFLAG_GROUTE)) {
			send_me_numericNA(sptr, ERR_NOPRIVILEGES);
		}
	}

	if (parc < 2 || BadPtr(parv[1])) {
		send_me_numeric(sptr, ERR_NEEDMOREPARAMS, "CONNECT");
		return 0;
	}

	if (use_or_deliver(cptr, sptr, &CMD_CONNECT, "%s %s :%s", 3, parc, parv) != HUNTED_ISME) {
		return 0;
	}

	if ((acptr = find_server(parv[1], NULL)) != NULL) {
		send_me_notice(sptr, ":*** Connect: server %s already exists from %s.",
			parv[1], acptr->from->name);
		return 0;
	}

	if ((linkp = find_link(parv[1], "*")) == NULL) {
		send_me_notice(sptr, ":*** Connect: no link configuration found for %s.", parv[1]);
		return 0;
	}

	tmpport = port = linkp->port;
	if (parc > 2 && !BadPtr(parv[2])) {
		if ((port = atoi(parv[2])) <= 0) {
			send_me_noticeNA(sptr, ":*** Connect: illegal port number.");
			return 0;
		}
	}

	send_gnotice("%s CONNECT %s %s from %s", MyClient(sptr) ? "Local" : "Remote",
		parv[1], (!BadPtr(parv[2])) ? parv[2] : "", sptr->name);
	sendto_serv_msg_butone(NULL, &me, &CMD_GNOTICE, ":%s CONNECT %s %s from %s",
		MyClient(sptr) ? "Local" : "Remote", parv[1],
		(!BadPtr(parv[2])) ? parv[2] : "", sptr->name);
	ircdlog(LOG_SERVER, "CONNECT from %s: %s %s", sptr->name, parv[1],
		!BadPtr(parv[2]) ? parv[2] : "*");

	inpath = HasMode(sptr, UMODE_RSTAFF) ? linkp->host : HIDDEN_IP;
	linkp->port = port;

	if (serv_connect(linkp, sptr)) {
		send_me_notice(sptr, ":*** Connecting to %s[%s].%d.", linkp->servername,
			inpath, linkp->port);
	}
	else {
		send_me_notice(sptr, ":*** Couldn't connect to %s[%s].%d.", linkp->servername,
			inpath, linkp->port);
	}

	linkp->port = tmpport;
	return 0;
}
