/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_admin.c,v 1.30.2.2 2005/01/15 23:53:31 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "hook.h"
#include "modules.h"
#include "xmode.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_admin) = {
	"m_admin",
	"/ADMIN command",
	6, "$Revision: 1.30.2.2 $"
};

int MOD_LOAD(m_admin)()
{
	if (register_command(&MOD_HEADER(m_admin), &CMD_ADMIN, m_admin) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_admin)()
{
	return MOD_SUCCESS;
}

/*
 * m_admin
 *	parv[0] = sender prefix
 *	parv[1] = servername
 */
int m_admin(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	static time_t last_used = 0L;

	if (use_or_deliver(cptr, sptr, &CMD_ADMIN, ":%s", 1, parc, parv) != HUNTED_ISME) {
		return 0;
	}
	if (!HasMode(sptr, UMODE_OPER)) {
		if (FloodConfig.pace_wait_simple && (last_used + FloodConfig.pace_wait_simple > timeofday)) {
			send_me_numericNA(sptr, RPL_LOAD2HI);
			return 0;
		}
		else {
			last_used = timeofday;
		}
		if (GeneralConfig.spy_notices && IsPerson(sptr)) {
			sendto_realops_lev(SPY_LEV, "ADMIN requested by %s (%s@%s) [%s]", sptr->name,
				sptr->username, MaskedHost(sptr), sptr->user->server);
		}
	}
	if (AdminInfo == NULL) {
		send_me_numeric(sptr, ERR_NOADMININFO, me.name);
		return 0;
	}

	send_me_numeric(sptr, RPL_ADMINME, me.name);
	if (!BadPtr(AdminInfo->name)) {
		send_me_numeric(sptr, RPL_ADMINLOC1, AdminInfo->name);
	}
	if (!BadPtr(AdminInfo->desc)) {
		send_me_numeric(sptr, RPL_ADMINLOC2, AdminInfo->desc);
	}
	if (!BadPtr(AdminInfo->email)) {
		send_me_numeric(sptr, RPL_ADMINEMAIL, AdminInfo->email);
	}
	return 0;
}
