#!/bin/sh
#
#
# RageIRCd: an advanced Internet Relay Chat daemon (ircd).
# (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
#
# This software is free, licensed under the General Public License.
# Please refer to doc/LICENSE and doc/README for further details.
#
# $Id: commands.c.SH,v 1.6.2.11 2005/03/05 00:43:00 amcwilliam Exp $
#

printf "Generating commands wrapper... "

FIRST="m_oper m_join m_message m_mode m_nick"
CMDS="`for m in $*; do basename $m .c; done`"

cat >commands.c<<__EOF__
/* Automatically generated by commands.c.SH. Any changes will go away. */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include "setup.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

#ifdef DYNAMIC_WRAPPER
Module module_header = {
#else
Module commands_header = {
#endif
	"commands",
	"commands wrapper",
	6, "\$Revision: 1.6.2.11 $"
};

typedef struct _cmd_mod_info {
	Module *header;
	int (*load)();
	int (*unload)();
} cmd_mod_info;

static cmd_mod_info *m_ptr = NULL;
static cmd_mod_info cmd_mod_table[] = {
__EOF__

echo "/* Commands that have exported symbols first. */" >> commands.c
for m in $FIRST; do
	echo "{ &${m}_header, ${m}_load, ${m}_unload }," >> commands.c;
done

echo "/* And now everything else. */" >> commands.c
for c in $CMDS; do
	for i in $FIRST; do
		if test "x$c" = "x$i"; then
			c=""
			break
		fi
	done
	if test "x$c" != "x"; then
		echo "{ &${c}_header, ${c}_load, ${c}_unload }," >> commands.c
	fi
done

cat >>commands.c<<__EOF__
{ NULL, NULL, NULL }
};

#ifdef DYNAMIC_WRAPPER
int module_load()
#else
int commands_load()
#endif
{
	for (m_ptr = cmd_mod_table; m_ptr->header != NULL; m_ptr++) {
		if ((*m_ptr->load)() == MOD_FAILURE) {
			break; /* Dont bother loading any more if we fail */
		}
	}

	/* If we didn't finish walking the table, we broke out early */
	if (m_ptr->header != NULL) {
		if (m_ptr->header == cmd_mod_table[0].header) {
			/* This was our first entry, nothing to unload */
			m_ptr = NULL;
		}

		/* Now walk m_ptr backwards, and unload everything. */

		while (m_ptr != NULL) {
			clear_objects(m_ptr->header);
			(*m_ptr->unload)();

			if (m_ptr->header == cmd_mod_table[0].header) {
				m_ptr = NULL;
			}
			else {
				m_ptr--;
			}
		}

		return MOD_FAILURE;
	}

	/* Everything loaded ok, set the module perm. */
#ifdef DYNAMIC_WRAPPER
	module_header.flags |= MOD_FLAG_PERM;
#else
	commands_header.flags |= MOD_FLAG_PERM;
#endif

	return MOD_SUCCESS;
}

#ifdef DYNAMIC_WRAPPER
int module_unload()
#else
int commands_unload()
#endif
{
	/* m_ptr should be a pointer to our last entry (NULL buffer) */

	ASSERT(m_ptr != NULL);
	ASSERT(m_ptr->header == NULL);
	m_ptr--;
	ASSERT(m_ptr->header != NULL);

	/* We now walk backwards and unload everything */
	while (m_ptr != NULL) {
		clear_objects(m_ptr->header);
		(*m_ptr->unload)();

		if (m_ptr->header == cmd_mod_table[0].header) {
			m_ptr = NULL;
		}
		else {
			m_ptr--;
		}
	}

	return MOD_SUCCESS;
}

__EOF__

printf "done.\n"
