/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: sbuf.h,v 1.7.2.1 2004/12/07 03:04:53 pneumatus Exp $
 */

#ifndef __sbuf_include__
#define __sbuf_include__

typedef struct _SBuf SBuf;
typedef struct _SBuffer SBuffer;
typedef struct _SBufBlock SBufBlock;
typedef struct _SBufUser SBufUser;
typedef struct _SBufUserBlock SBufUserBlock;

struct _SBuf {
	SBufUser *head;
	SBufUser *tail;
	int length;
};

struct _SBuffer {
	SBuffer *next;
	int shared;
	int bufsize;
	int refcount;
	char *end;
};

struct _SBufBlock {
	SBufBlock *next;
	SBuffer *bufs;
	int num;
};

struct _SBufUser {
	SBufUser *next;
	char *start;
	SBuffer *buf;
};

struct _SBufUserBlock {
	SBufUserBlock *next;
	SBufUser *users;
	int num;
};

#define SBUF_LARGE_BUFFER	512
#define SBUF_SMALL_BUFFER	256

#define SBUF_BASE		sizeof(SBuffer)
#define SBUF_LARGE_TOTAL	(SBUF_BASE + SBUF_LARGE_BUFFER)
#define SBUF_SMALL_TOTAL	(SBUF_BASE + SBUF_SMALL_BUFFER)

#define IsEOL(cc)		(((cc) == '\r') || ((cc) == '\n'))
#define SBufLength(ss)		((ss)->length)
#define SBufClear(ss)		sbuf_delete((ss), (ss)->length)

extern void init_sbuf();
extern SBuffer *sbuf_alloc(int);
extern SBufUser *user_alloc();
extern int sbuf_alloc_error();
extern int sbuf_begin_share(const char *, int, void **);
extern void sbuf_end_share(void **, int);
extern int sbuf_put_share(SBuf *, void *);
extern int sbuf_put(SBuf *, const char *, int);
extern void sbuf_delete(SBuf *, int);
extern char *sbuf_map(SBuf *, int *);
extern int sbuf_flush(SBuf *);
extern int sbuf_getmsg(SBuf *, char *, int);
extern int sbuf_get(SBuf *, char *, int);

extern int sbuf_small_used, sbuf_small_total;
extern int sbuf_large_used, sbuf_large_total;
extern int sbuf_user_used, sbuf_user_total;
extern int sbuf_blocks_used, sbuf_userblocks_used;


#endif /* __sbuf_include__ */
