/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: channel.h,v 1.9.2.1 2004/12/07 03:04:34 pneumatus Exp $
 */

#ifndef	__channel_include__
#define __channel_include__

#define find_channel(chname, chptr) hash_find_channel(chname, chptr)

#define CREATE			1	/* whether a channel should be created or just tested for existance */
#define MODEBUFLEN		200	/* max modebuf we consider from users */
#define REALMODEBUFLEN		512	/* max actual modebuf */

#define ChannelExists(n) 	(find_channel(n, NULL) != NULL)

#define MAXMODEPARAMSUSER	6
#define	MAXMODEPARAMS		(MAXPARA - 4)
#define MAXTSMODEPARAMS		(MAXPARA - 5)

#define ALL_MEMBERS		0

/* can_send() return values */
enum {
	CANT_SEND_MODERATED = 1, /* 0 means we CAN send */
	CANT_SEND_NOPRIVMSGS,
	CANT_SEND_MODREGONLY,
	CANT_SEND_BANNED,
	CANT_SEND_COLOUR,
	CANT_SEND_DCC,
	CANT_SEND_CTCP
};

extern const char *msg_errors[];
#define msg_error(x, y, z) send_me_numeric((x), ERR_CANNOTSENDTOCHAN, (z), msg_errors[(y)])

#endif /* __channel_include__ */
