`plot.blast` <-
function(b, cutoff=110) {
  ##- Plot alignment stats
  par(mfcol=c(4,1), mar=c(4, 4, 1, 2), cex.lab=1.5)
  plot(b$mlog.evalue, xlab="Hit No", ylab="-log(Evalue)")
  if(!is.null(cutoff))
    abline(h=cutoff, col="red", lty=3)
  plot(b$bitscore, xlab="Hit No", ylab="Bitscore")
  plot(b$hit.tbl[,"identity"], xlab="Hit No", ylab="Identity")
  plot(b$hit.tbl[,"alignmentlength"], xlab="Hit No", ylab="Length")

  i <- b$mlog.evalue >= cutoff
  out <- cbind(b$pdb.id[i], b$gi.id[i])
  rownames(out) <- which(i)
  colnames(out) <- c("pdb.id", "gi.id")
  return(out)
}

