% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github.R
\name{use_github_links}
\alias{use_github_links}
\title{Use GitHub links in URL and BugReports}
\usage{
use_github_links(auth_token = NULL, host = "https://api.github.com",
  overwrite = FALSE)
}
\arguments{
\item{auth_token}{Provide a personal access token (PAT) from
\url{https://github.com/settings/tokens}. If \code{NULL}, will use the logic
described in \code{\link[gh:gh_whoami]{gh::gh_whoami()}} to look for a token stored in an environment
variable. Use \code{\link[=browse_github_pat]{browse_github_pat()}} to help set up your PAT.}

\item{host}{GitHub API host to use. Override with the endpoint-root for your
GitHub enterprise instance, for example,
"https://github.hostname.com/api/v3"}

\item{overwrite}{By default, \code{use_github_links()} will not overwrite existing
fields. Set to \code{TRUE} to overwrite existing links.}
}
\description{
Populates the \code{URL} and \code{BugReports} fields of a GitHub-using R package with
appropriate links.
}
\examples{
\dontrun{
use_github_links()
}

}
