% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/length.R
\name{stri_isempty}
\alias{stri_isempty}
\title{Determine if a String is of Length Zero}
\usage{
stri_isempty(str)
}
\arguments{
\item{str}{character vector or an object coercible to}
}
\value{
Returns a logical vector of the same length as \code{str}.
}
\description{
This is the fastest way to find out
whether the elements of a character vector are empty strings.
}
\details{
Missing values are handled properly.
}
\examples{
stri_isempty(letters[1:3])
stri_isempty(c(',', '', 'abc', '123', '\\u0105\\u0104'))
stri_isempty(character(1))

}
\seealso{
Other length: \code{\link{stri_length}},
  \code{\link{stri_numbytes}}, \code{\link{stri_width}}
}
