% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/session.R
\name{jump_to}
\alias{jump_to}
\alias{follow_link}
\title{Navigate to a new url.}
\usage{
jump_to(x, url, ...)

follow_link(x, i, css, xpath, ...)
}
\arguments{
\item{x}{A session.}

\item{url}{A URL, either relative or absolute, to navigate to.}

\item{...}{Any additional httr configs to apply to this request.}

\item{i}{You can select with: \describe{
\item{an integer}{selects the ith link}
\item{a string}{first link containing that text (case sensitive)}
}}

\item{css}{Nodes to select. Supply one of \code{css} or \code{xpath}
depending on whether you want to use a CSS or XPath 1.0 selector.}

\item{xpath}{Nodes to select. Supply one of \code{css} or \code{xpath}
depending on whether you want to use a CSS or XPath 1.0 selector.}
}
\description{
\code{jump_to()} takes a url (either relative or absolute);
\code{follow_link} takes an expression that refers to a link (an \verb{<a>}
tag) on the current page.
}
\examples{
\donttest{
s <- html_session("http://hadley.nz")
s <- s \%>\% follow_link("github")
s <- s \%>\% back()
s \%>\% follow_link("readr")
}
}
