% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse.R
\name{html}
\alias{html}
\alias{read_xml.session}
\title{Parse an HTML page.}
\usage{
html(x, ..., encoding = "")

\method{read_xml}{session}(x, ..., as_html = FALSE)
}
\arguments{
\item{x}{A url, a local path, a string containing html, or a response from
an httr request.}

\item{...}{If \code{x} is a URL, additional arguments are passed on to
\code{\link[httr:GET]{httr::GET()}}.}

\item{encoding}{Specify encoding of document. See \code{\link[=iconvlist]{iconvlist()}}
for complete list. If you have problems determining the correct encoding,
try \code{\link[stringi:stri_enc_detect]{stringi::stri_enc_detect()}}}

\item{as_html}{Optionally parse an xml file as if it's html.}
}
\description{
html is deprecated: please use \code{xml2::read_html()} instead.
}
\examples{
# From a url:
google <- read_html("http://google.com", encoding = "ISO-8859-1")
google \%>\% xml_structure()
google \%>\% html_nodes("div")

# From a string: (minimal html 5 document)
# http://www.brucelawson.co.uk/2010/a-minimal-html5-document/
minimal <- read_html("<!doctype html>
  <meta charset=utf-8>
 <title>blah</title>
 <p>I'm the content")
minimal
minimal \%>\% xml_structure()

# From an httr request
google2 <- read_html(httr::GET("http://google.com"))
}
\keyword{internal}
