% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table.R
\docType{methods}
\name{dbReadTable,SQLiteConnection,character-method}
\alias{dbReadTable,SQLiteConnection,character-method}
\title{Read a database table}
\usage{
\S4method{dbReadTable}{SQLiteConnection,character}(conn, name, ...,
  row.names = NA, check.names = TRUE, select.cols = "*")
}
\arguments{
\item{conn}{a \code{\linkS4class{SQLiteConnection}} object, produced by
\code{\link[DBI:dbConnect]{DBI::dbConnect()}}}

\item{name}{a character string specifying a table name. SQLite table names
are \emph{not} case sensitive, e.g., table names \code{ABC} and \code{abc}
are considered equal.}

\item{...}{Needed for compatibility with generic. Otherwise ignored.}

\item{row.names}{Either \code{TRUE}, \code{FALSE}, \code{NA} or a string.

  If \code{TRUE}, always translate row names to a column called "row_names".
  If \code{FALSE}, never translate row names. If \code{NA}, translate
  rownames only if they're a character vector.

  A string is equivalent to \code{TRUE}, but allows you to override the
  default name.

  For backward compatibility, \code{NULL} is equivalent to \code{FALSE}.}

\item{check.names}{If \code{TRUE}, the default, column names will be
converted to valid R identifiers.}

\item{select.cols}{A SQL expression (in the form of a character vector of
length 1) giving the columns to select. E.g. \code{"*"} selects all columns,
\code{"x, y, z"} selects three columns named as listed.}
}
\value{
A data frame.
}
\description{
Returns the contents of a database table given by name as a data frame.
}
\details{
Note that the data frame returned by \code{dbReadTable()} only has
primitive data, e.g., it does not coerce character data to factors.
}
\examples{
library(DBI)
db <- RSQLite::datasetsDb()
dbReadTable(db, "mtcars")
dbReadTable(db, "mtcars", row.names = FALSE)
dbReadTable(db, "mtcars", select.cols = "cyl, gear")
dbReadTable(db, "mtcars", select.cols = "row_names, cyl, gear")
dbDisconnect(db)
}
\seealso{
The corresponding generic function \code{\link[DBI:dbReadTable]{DBI::dbReadTable()}}.
}
