% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call.R
\name{is_callable}
\alias{is_callable}
\title{Is an object callable?}
\usage{
is_callable(x)
}
\arguments{
\item{x}{An object to test.}
}
\description{
A callable object is an object that can appear in the function
position of a call (as opposed to argument position). This includes
\link[=is_symbolic]{symbolic objects} that evaluate to a function or
literal functions embedded in the call.
}
\details{
Note that strings may look like callable objects because
expressions of the form \code{"list"()} are valid R code. However,
that's only because the R parser transforms strings to symbols. It
is not legal to manually set language heads to strings.
}
\examples{
# Symbolic objects and functions are callable:
is_callable(quote(foo))
is_callable(base::identity)

# node_poke_car() lets you modify calls without any checking:
lang <- quote(foo(10))
node_poke_car(lang, get_env())

# Use is_callable() to check an input object is safe to put as CAR:
obj <- base::identity

if (is_callable(obj)) {
  lang <- node_poke_car(lang, obj)
} else {
  abort("`obj` must be callable")
}

eval_bare(lang)
}
