% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coerce-gpc-methods.R
\name{coerce-gpc-methods}
\alias{coerce-gpc-methods}
\alias{owin2gpc}
\alias{gpc2owin}
\alias{as.owin.gpc.poly}
\title{Conversion between polygonal \code{"owin"} and \code{"gpc.poly"}}
\usage{
owin2gpc(object)

gpc2owin(object, ...)

as.owin.gpc.poly(W, ...)
}
\arguments{
\item{object}{an object of class \code{"gpc.poly"} or \code{"owin"},
respectively.}

\item{...}{further arguments passed to \code{\link[spatstat]{owin}}.}

\item{W}{an object of class \code{"gpc.poly"}.}
}
\value{
The converted polygon of class \code{"gpc.poly"} or \code{"owin"},
respectively. If neither package \pkg{rgeos} nor \pkg{gpclib} are available,
\code{owin2gpc} will just return the \code{pts} slot of the
\code{"gpc.poly"} (no formal class) with a warning.
}
\description{
Package \pkg{polyCub} implements converters between the classes
\code{"\link[spatstat:owin.object]{owin}"} of package \pkg{spatstat} and
\code{"\link[rgeos:gpc.poly-class]{gpc.poly}"} of package \pkg{rgeos}
(originally from \pkg{gpclib}).
Support for the \code{"gpc.poly"} class was dropped from
\pkg{spatstat} as of version 1.34-0.
}
\note{
The converter \code{owin2gpc} requires the package \pkg{rgeos} (or
\pkg{gpclib}) for the formal class definition of a \code{"gpc.poly"}.
It will produce vertices ordered according to the \pkg{sp} convention,
i.e. clockwise for normal boundaries and anticlockwise for holes, where,
however, the first vertex is \emph{not} repeated!
}
\examples{
if (gpclibPermit() && require("spatstat")) {
    ## use example polygons from
    example(plotpolyf, ask = FALSE)

    letterR  # a simple "xylist"
    letterR.owin <- owin(poly = letterR)
    letterR.gpc_from_owin <- owin2gpc(letterR.owin)
    letterR.xylist_from_gpc <- xylist(letterR.gpc_from_owin)
    stopifnot(all.equal(letterR, lapply(letterR.xylist_from_gpc, "[", 1:2)))
    letterR.owin_from_gpc <- as.owin(letterR.gpc_from_owin)
    stopifnot(all.equal(letterR.owin, letterR.owin_from_gpc))
}
}
\seealso{
\code{\link{xylist}}, and the package \pkg{rgeos} for
conversions of \code{"gpc.poly"} objects from and to \pkg{sp}'s
\code{"\linkS4class{SpatialPolygons}"} class.
}
\author{
Sebastian Meyer
}
\keyword{methods}
\keyword{spatial}
