% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import-functions.R
\name{importTxt}
\alias{importTxt}
\alias{importTab}
\alias{importCsv}
\title{Import text files}
\usage{
importTxt(path, ...)

importTab(path, ...)

importCsv(path, ...)
}
\arguments{
\item{path}{\code{character}, path to directory or file which should be read
in.}

\item{\ldots}{arguments to be passed to \code{\link[utils]{read.table}}.}
}
\value{
a \code{list} of \code{\link[MALDIquant]{MassSpectrum-class}} or
\code{\link[MALDIquant]{MassPeaks-class}} objects (depending on the
\code{centroided} argument).
}
\description{
This function imports different text file formats
into \code{\link[MALDIquant]{MassSpectrum-class}} or
\code{\link[MALDIquant]{MassPeaks-class}} objects.
}
\details{
\code{importTab}, \code{importTxt} and \code{importCsv} use
\code{\link[utils]{read.table}} with different defaults.
}
\examples{

library("MALDIquant")
library("MALDIquantForeign")

## get example directory
exampleDirectory <- system.file("exampledata", package="MALDIquantForeign")

## import txt files
s <- importTxt(exampleDirectory)

## import csv files
s <- importCsv(exampleDirectory)

}
\references{
\url{https://strimmerlab.github.io/software/maldiquant/}
}
\seealso{
\code{\link[MALDIquant]{MassSpectrum-class}},
\code{\link[MALDIquant]{MassPeaks-class}},
\code{\link[utils]{read.table}}
}
\author{
Sebastian Gibb
}
