% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Scorrect-confint2.R, R/Scorrect-model.tables.R
\name{confint2}
\alias{confint2}
\alias{confint2.lvmfit}
\alias{model.tables2}
\title{Confidence Intervals With Small Sample Correction}
\usage{
confint2(object, robust, cluster, transform, as.lava, conf.level, ...)

\method{confint2}{lvmfit}(
  object,
  robust = FALSE,
  cluster = NULL,
  transform = NULL,
  as.lava = TRUE,
  conf.level = 0.95,
  ssc = lava.options()$ssc,
  df = lava.options()$df,
  ...
)

model.tables2(object, robust, cluster, transform, as.lava, conf.level, ...)
}
\arguments{
\item{object}{a \code{lvmfit} or \code{lvmfit2} object (i.e. output of \code{lava::estimate} or \code{lavaSearch2::estimate2}).}

\item{robust}{[logical] should robust standard errors be used instead of the model based standard errors? Should be \code{TRUE} if argument cluster is not \code{NULL}.}

\item{cluster}{[integer vector] the grouping variable relative to which the observations are iid.}

\item{transform}{[function] transformation to be applied.}

\item{as.lava}{[logical] when \code{TRUE} uses the same names as when using \code{stats::coef}.}

\item{conf.level}{[numeric, 0-1] level of the confidence intervals.}

\item{...}{additional argument passed to \code{estimate2} when using a \code{lvmfit} object.}

\item{ssc}{[character] method used to correct the small sample bias of the variance coefficients: no correction (code{"none"}/\code{FALSE}/\code{NA}),
correct the first order bias in the residual variance (\code{"residual"}), or correct the first order bias in the estimated coefficients \code{"cox"}).
Only relevant when using a \code{lvmfit} object.}

\item{df}{[character] method used to estimate the degree of freedoms of the Wald statistic: Satterthwaite \code{"satterthwaite"}. 
Otherwise (\code{"none"}/code{FALSE}/code{NA}) the degree of freedoms are set to \code{Inf}.
Only relevant when using a \code{lvmfit} object.}
}
\value{
A data.frame with a row per coefficient.

A data.frame with a row per coefficient.
}
\description{
Extract confidence intervals of the coefficients from a latent variable model.
Similar to \code{lava::confint} but with small sample correction.

Extract estimate, standard error, confidence intervals and p-values associated to each coefficient of a latent variable model.
Similar to \code{lava::confint} but with small sample correction.
}
\details{
When argument object is a \code{lvmfit} object, the method first calls \code{estimate2} and then extract the confidence intervals.

When argument object is a \code{lvmfit} object, the method first calls \code{estimate2} and then extract the confidence intervals.
}
\examples{
#### simulate data ####
set.seed(10)
dW <- sampleRepeated(10, format = "wide")
set.seed(10)
dL <- sampleRepeated(10, format = "long")
dL$time2 <- paste0("visit",dL$time)

#### latent variable models ####
e.lvm <- estimate(lvm(c(Y1,Y2,Y3) ~ 1*eta + X1, eta ~ Z1), data = dW)
confint(e.lvm)
confint2(e.lvm)
confint2(e.lvm, as.lava = FALSE)
}
\concept{extractor}
\keyword{smallSampleCorrection}
