% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw.R
\name{draw_plot}
\alias{draw_plot}
\title{Draw a (sub)plot.}
\usage{
draw_plot(
  plot,
  x = 0,
  y = 0,
  width = 1,
  height = 1,
  scale = 1,
  hjust = 0,
  vjust = 0,
  halign = 0.5,
  valign = 0.5
)
}
\arguments{
\item{plot}{The plot to place. Can be a ggplot2 plot, an arbitrary grob or gtable,
or a recorded base-R plot, as in \code{\link[=as_grob]{as_grob()}}.}

\item{x}{The x location of the plot. (Left side if \code{hjust = 0}.)}

\item{y}{The y location of the plot. (Bottom side if \code{vjust = 0}.)}

\item{width}{Width of the plot.}

\item{height}{Height of the plot.}

\item{scale}{Scales the grob relative to the rectangle defined by \code{x}, \code{y}, \code{width}, \code{height}. A setting
of \code{scale = 1} indicates no scaling.}

\item{hjust, vjust}{Horizontal and vertical justification relative to x.}

\item{halign, valign}{Horizontal and vertical justification of the plot inside
the box.}
}
\description{
Places a plot somewhere onto the drawing canvas. By default, coordinates run from
0 to 1, and the point (0, 0) is in the lower left corner of the canvas.
}
\examples{
library(ggplot2)

# make a plot
p <- ggplot(data.frame(x = 1:3, y = 1:3), aes(x, y)) +
    geom_point()
# draw into the top-right corner of a larger plot area
ggdraw() + draw_plot(p, .6, .6, .4, .4)
}
