% Generated by roxygen2 (4.0.1): do not edit by hand
\name{checkFactor}
\alias{assertFactor}
\alias{checkFactor}
\alias{testFactor}
\title{Check if an argument is a factor}
\usage{
checkFactor(x, levels = NULL, ordered = NA, empty.levels.ok = TRUE,
  any.missing = TRUE, all.missing = TRUE, len = NULL, min.len = NULL,
  max.len = NULL, unique = FALSE, names = NULL)

assertFactor(x, levels = NULL, ordered = NA, empty.levels.ok = TRUE,
  any.missing = TRUE, all.missing = TRUE, len = NULL, min.len = NULL,
  max.len = NULL, unique = FALSE, names = NULL, .var.name)

testFactor(x, levels = NULL, ordered = NA, empty.levels.ok = TRUE,
  any.missing = TRUE, all.missing = TRUE, len = NULL, min.len = NULL,
  max.len = NULL, unique = FALSE, names = NULL)
}
\arguments{
\item{x}{[ANY]\cr
Object to check.}

\item{.var.name}{[character(1)]\cr
Name for \code{x}. Defaults to a heuristic to determine
the name using \code{\link[base]{deparse}} and \code{\link[base]{substitute}}.}

\item{levels}{[\code{character}]\cr
Vector of allowed factor levels.}

\item{ordered}{[\code{logical(1)}]\cr
Check for an ordered factor? If \code{FALSE} or \code{TRUE}, checks explicitly
for an unordered or ordered factor, respectively.
Default is \code{NA} which does not perform a check.}

\item{empty.levels.ok}{[\code{logical(1)}]\cr
Are empty levels allowed?
Default is \code{TRUE}.}

\item{any.missing}{[\code{logical(1)}]\cr
Are vectors with missing values allowed? Default is \code{TRUE}.}

\item{all.missing}{[\code{logical(1)}]\cr
Are vectors with only missing values allowed? Default is \code{TRUE}.}

\item{len}{[\code{integer(1)}]\cr
Exact expected length of \code{x}.}

\item{min.len}{[\code{integer(1)}]\cr
Minimal length of \code{x}.}

\item{max.len}{[\code{integer(1)}]\cr
Maximal length of \code{x}.}

\item{unique}{[\code{logical(1)}]\cr
Must all values be unique? Default is \code{FALSE}.}

\item{names}{[\code{character(1)}]\cr
Check for names. See \code{\link{checkNamed}} for possible values.
Default is \dQuote{any} which performs no check at all.}
}
\value{
Depending on the function prefix:
 If the check is successful, all functions return \code{TRUE}.
 If the check is not successful, \code{assertFactor} throws an error message,
 \code{testFactor} returns \code{FALSE} and \code{checkFactor} returns
 a string with the error message.
}
\description{
Check if an argument is a factor
}
\examples{
x = factor("a", levels = c("a", "b"))
 testFactor(x)
 testFactor(x, empty.levels.ok = FALSE)
}
\seealso{
Other basetypes: \code{\link{assertArray}},
  \code{\link{checkArray}}, \code{\link{testArray}};
  \code{\link{assertAtomicVector}},
  \code{\link{checkAtomicVector}},
  \code{\link{testAtomicVector}};
  \code{\link{assertAtomic}}, \code{\link{checkAtomic}},
  \code{\link{testAtomic}}; \code{\link{assertCharacter}},
  \code{\link{checkCharacter}},
  \code{\link{testCharacter}}; \code{\link{assertComplex}},
  \code{\link{checkComplex}}, \code{\link{testComplex}};
  \code{\link{assertDataFrame}},
  \code{\link{checkDataFrame}},
  \code{\link{testDataFrame}};
  \code{\link{assertEnvironment}},
  \code{\link{checkEnvironment}},
  \code{\link{testEnvironment}};
  \code{\link{assertFunction}},
  \code{\link{checkFunction}}, \code{\link{testFunction}};
  \code{\link{assertIntegerish}},
  \code{\link{checkIntegerish}},
  \code{\link{testIntegerish}};
  \code{\link{assertInteger}}, \code{\link{checkInteger}},
  \code{\link{testInteger}}; \code{\link{assertList}},
  \code{\link{checkList}}, \code{\link{testList}};
  \code{\link{assertLogical}}, \code{\link{checkLogical}},
  \code{\link{testLogical}}; \code{\link{assertMatrix}},
  \code{\link{checkMatrix}}, \code{\link{testMatrix}};
  \code{\link{assertNumeric}}, \code{\link{checkNumeric}},
  \code{\link{testNumeric}}; \code{\link{assertVector}},
  \code{\link{checkVector}}, \code{\link{testVector}}
}

