% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats-anova-tidiers.R
\name{tidy.anova}
\alias{tidy.anova}
\title{Tidy a(n) anova object}
\usage{
\method{tidy}{anova}(x, ...)
}
\arguments{
\item{x}{An \code{anova} object, such as those created by \code{\link[stats:anova]{stats::anova()}},
\code{\link[car:Anova]{car::Anova()}}, \code{\link[car:leveneTest]{car::leveneTest()}}, or \code{\link[car:linearHypothesis]{car::linearHypothesis()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Two exceptions here are:
\itemize{
\item \code{tidy()} methods will warn when supplied an \code{exponentiate} argument if
it will be ignored.
\item \code{augment()} methods will warn when supplied a \code{newdata} argument if it
will be ignored.
}}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies across models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\details{
The \code{term} column of an ANOVA table can come with leading or
trailing whitespace, which this tidying method trims.

For documentation on the tidier for \code{\link[car:leveneTest]{car::leveneTest()}} output, see
\code{\link[=tidy.leveneTest]{tidy.leveneTest()}}
}
\examples{
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# fit models
a <- lm(mpg ~ wt + qsec + disp, mtcars)
b <- lm(mpg ~ wt + qsec, mtcars)

mod <- anova(a, b)

# summarize model fit with tidiers
tidy(mod)
glance(mod)

# car::linearHypothesis() example
library(car)
mod_lht <- linearHypothesis(a, "wt - disp")
tidy(mod_lht)
glance(mod_lht)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[stats:anova]{stats::anova()}}, \code{\link[car:Anova]{car::Anova()}}, \code{\link[car:leveneTest]{car::leveneTest()}}

Other anova tidiers: 
\code{\link{glance.anova}()},
\code{\link{glance.aov}()},
\code{\link{tidy.TukeyHSD}()},
\code{\link{tidy.aovlist}()},
\code{\link{tidy.aov}()},
\code{\link{tidy.manova}()}
}
\concept{anova tidiers}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
  \item{df}{Degrees of freedom used by this term in the model.}
  \item{meansq}{Mean sum of squares. Equal to total sum of squares divided by degrees of freedom.}
  \item{p.value}{The two-sided p-value associated with the observed statistic.}
  \item{statistic}{The value of a T-statistic to use in a hypothesis that the regression term is non-zero.}
  \item{sumsq}{Sum of squares explained by this term.}
  \item{term}{The name of the regression term.}

}
