% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats-htest-tidiers.R
\name{tidy.htest}
\alias{tidy.htest}
\alias{htest_tidiers}
\alias{glance.htest}
\title{Tidy/glance a(n) htest object}
\usage{
\method{tidy}{htest}(x, ...)

\method{glance}{htest}(x, ...)
}
\arguments{
\item{x}{An \code{htest} objected, such as those created by \code{\link[stats:cor.test]{stats::cor.test()}},
\code{\link[stats:t.test]{stats::t.test()}}, \code{\link[stats:wilcox.test]{stats::wilcox.test()}}, \code{\link[stats:chisq.test]{stats::chisq.test()}}, etc.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\value{
A one-row \link[tibble:tibble]{tibble::tibble} with one or more of the following
columns, depending on which hypothesis test was used.

\item{estimate}{Estimate of the effect size}
\item{statistic}{Test statistic used to compute the p-value}
\item{p.value}{P-value}
\item{parameter}{Parameter field in the htest, typically degrees of
freedom}
\item{conf.low}{Lower bound on a confidence interval}
\item{conf.high}{Upper bound on a confidence interval}
\item{estimate1}{Sometimes two estimates are computed, such as in a
two-sample t-test}
\item{estimate2}{Sometimes two estimates are computed, such as in a
two-sample t-test}
\item{method}{Method used to compute the statistic as a string}
\item{alternative}{Alternative hypothesis as a string}
}
\description{
For models that have only a single component, the \code{\link[=tidy]{tidy()}} and
\code{\link[=glance]{glance()}} methods are identical. Please see the documentation for both
of those methods.
}
\examples{

tt <- t.test(rnorm(10))
tidy(tt)
glance(tt)  # same output for all htests

tt <- t.test(mpg ~ am, data = mtcars)
tidy(tt)

wt <- wilcox.test(mpg ~ am, data = mtcars, conf.int = TRUE, exact = FALSE)
tidy(wt)

ct <- cor.test(mtcars$wt, mtcars$mpg)
tidy(ct)

chit <- chisq.test(xtabs(Freq ~ Sex + Class, data = as.data.frame(Titanic)))
tidy(chit)
augment(chit)

}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[stats:cor.test]{stats::cor.test()}}, \code{\link[stats:t.test]{stats::t.test()}},
\code{\link[stats:wilcox.test]{stats::wilcox.test()}}, \code{\link[stats:chisq.test]{stats::chisq.test()}}

Other htest tidiers: \code{\link{augment.htest}},
  \code{\link{tidy.pairwise.htest}},
  \code{\link{tidy.power.htest}}
}
\concept{htest tidiers}
