% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aer-tidiers.R
\name{glance.ivreg}
\alias{glance.ivreg}
\title{Glance at a(n) ivreg object}
\usage{
\method{glance}{ivreg}(x, diagnostics = FALSE, ...)
}
\arguments{
\item{x}{An \code{ivreg} object created by a call to \code{\link[AER:ivreg]{AER::ivreg()}}.}

\item{diagnostics}{Logical indicating whether to include statistics and
p-values for Sargan, Wu-Hausman and weak instrument tests. Defaults to
\code{FALSE}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\value{
A one-row tibble with columns
\item{r.squared}{The percent of variance explained by the model}
\item{adj.r.squared}{r.squared adjusted based on the degrees of freedom}
\item{sigma}{The square root of the estimated residual variance}
\item{statistic}{Wald test statistic}
\item{p.value}{p-value from the Wald test}
\item{df}{Degrees of freedom used by the coefficients}
\item{df.residual}{residual degrees of freedom}

If \code{diagnostics = TRUE}, will also return the following columns:
\item{statistic.Sargan}{Statistic for Sargan test}
\item{p.value.Sargan}{P-value for Sargan test}
\item{statistic.Wu.Hausman}{Statistic for Wu-Hausman test}
\item{p.value.Wu.Hausman}{P-value for Wu-Hausman test}
\item{statistic.weakinst}{Statistic for Wu-Hausman test}
\item{p.value.weakinst}{P-value for weak instruments test}
}
\description{
Glance accepts a model object and returns a \code{\link[tibble:tibble]{tibble::tibble()}}
with exactly one row of model summaries. The summaries are typically
goodness of fit measures, p-values for hypothesis tests on residuals,
or model convergence information.

Glance never returns information from the original call to the modelling
function. This includes the name of the modelling function or any
arguments passed to the modelling function.

Glance does not calculate summary measures. Rather, it farms out these
computations to appropriate methods and gathers the results together.
Sometimes a goodness of fit measure will be undefined. In these cases
the measure will be reported as \code{NA}.
}
\examples{

library(AER)

data("CigarettesSW", package = "AER")
ivr <- ivreg(
  log(packs) ~ income | population,
  data = CigarettesSW,
  subset = year == "1995"
)

summary(ivr)

tidy(ivr)
tidy(ivr, conf.int = TRUE)
tidy(ivr, conf.int = TRUE, exponentiate = TRUE)

augment(ivr)

glance(ivr)

}
\seealso{
\code{\link[=glance]{glance()}}, \code{\link[AER:ivreg]{AER::ivreg()}}

Other ivreg tidiers: \code{\link{augment.ivreg}},
  \code{\link{tidy.ivreg}}
}
\concept{ivreg tidiers}
