% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/broom.R
\name{augment}
\alias{augment}
\title{Augment data with information from a(n) statistical object}
\usage{
augment(x, ...)
}
\arguments{
\item{x}{Model object or other R object with information to append to
observations.}

\item{...}{Addition arguments to augment method.}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with information about data points.
}
\description{
Augment accepts a model object and a dataset and adds
information about each observation in the dataset. Most commonly, this
includes predicted values in the \code{.fitted} column, residuals in the
\code{.resid} column, and standard errors for the fitted values in a \code{.se.fit}
column. New columns always begin with a \code{.} prefix to avoid overwriting
columns in the original dataset.

Users may pass data to augment via either the \code{data} argument or the
\code{newdata} argument. If the user passes data to the \code{data} argument,
it \strong{must} be exactly the data that was used to fit the model
object. Pass datasets to \code{newdata} to augment data that was not used
during model fitting. This still requires that all columns used to fit
the model are present.

Augment will often behavior different depending on whether \code{data} or
\code{newdata} is specified. This is because there is often information
associated with training observations (such as influences or related)
measures that is not meaningfully defined for new observations.

For convenience, many augment methods provide default \code{data} arguments,
so that \code{augment(fit)} will return the augmented training data. In these
cases augment tries to reconstruct the original data based on the model
object, with some varying degrees of success.

The augmented dataset is always returned as a \link[tibble:tibble]{tibble::tibble} with the
\strong{same number of rows} as the passed dataset. This means that the
passed data must be coercible to a tibble. At this time, tibbles do not
support matrix-columns. This means you should not specify a matrix
of covariates in a model formula during the original model fitting
process, and that \code{\link[splines:ns]{splines::ns()}}, \code{\link[stats:poly]{stats::poly()}} and
\code{\link[survival:Surv]{survival::Surv()}} objects are not supported in input data. If you
encounter errors, try explicitly passing a tibble, or fitting the original
model on data in a tibble.

We are in the process of defining behaviors for models fit with various
\link{na.action} arguments, but make no guarantees about behavior when data is
missing at this time.
}
\details{
The second argument is almost always \code{data}, which specifies the
original data object. This is not part of the S3
signature, partly because it prevents \link{rowwise_df_tidiers} from
taking a column name as the first argument. The tidiers are currently
deprecated and will soon be removed from broom, at which point
\code{data} will become part of the augment signature.

\strong{Historical note}: This generic originated in the ggplot2 package,
where it was called \code{fortify}.
}
\seealso{
\code{\link[=augment.lm]{augment.lm()}}
}
