% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strand_bias_test.R
\name{strand_bias_test}
\alias{strand_bias_test}
\title{Significance test for strand asymmetry}
\usage{
strand_bias_test(strand_occurrences)
}
\arguments{
\item{strand_occurrences}{Dataframe with mutation count per strand, result
from strand_occurrences()}
}
\value{
Dataframe with poisson test P value for the ratio between the
two strands per group per base substitution type.
}
\description{
This function performs a Poisson test for the ratio between mutations on 
each strand
}
\examples{
## See the 'mut_matrix_stranded()' example for how we obtained the
## following mutation matrix.
mut_mat_s <- readRDS(system.file("states/mut_mat_s_data.rds",
                                    package="MutationalPatterns"))

## Load a reference genome.
ref_genome <- "BSgenome.Hsapiens.UCSC.hg19"
library(ref_genome, character.only = TRUE)

tissue <- c("colon", "colon", "colon",
            "intestine", "intestine", "intestine",
            "liver", "liver", "liver")

## Perform the strand bias test.
strand_counts = strand_occurrences(mut_mat_s, by=tissue)
strand_bias = strand_bias_test(strand_counts)

}
\seealso{
\code{\link{mut_matrix_stranded}},
\code{\link{strand_occurrences}},
\code{\link{plot_strand_bias}}
}
