% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_strand_bias.R
\name{plot_strand_bias}
\alias{plot_strand_bias}
\title{Plot strand bias per base substitution type per group}
\usage{
plot_strand_bias(strand_bias, colors)
}
\arguments{
\item{strand_bias}{data.frame, result from strand_bias function}

\item{colors}{Optional color vector with 6 values for plotting}
}
\value{
Barplot
}
\description{
Plot strand bias per base substitution type per group
}
\examples{
## See the 'mut_matrix_stranded()' example for how we obtained the
## following mutation matrix.
mut_mat_s <- readRDS(system.file("states/mut_mat_s_data.rds",
                                    package="MutationalPatterns"))

## Load a reference genome.
ref_genome <- "BSgenome.Hsapiens.UCSC.hg19"
library(ref_genome, character.only = TRUE)

tissue <- c("colon", "colon", "colon",
            "intestine", "intestine", "intestine",
            "liver", "liver", "liver")

## Perform the strand bias test.
strand_counts = strand_occurrences(mut_mat_s, by=tissue)
strand_bias = strand_bias_test(strand_counts)

## Plot the strand bias.
plot_strand_bias(strand_bias)

}
\seealso{
\code{\link{mut_matrix_stranded}},
\code{\link{strand_occurrences}},
\code{\link{strand_bias_test}}
\code{\link{plot_strand}}
}
