% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_contribution_heatmap.R
\name{plot_contribution_heatmap}
\alias{plot_contribution_heatmap}
\title{Plot signature contribution heatmap}
\usage{
plot_contribution_heatmap(contribution, sig_order, cluster_samples = TRUE,
  method = "complete", plot_values = FALSE)
}
\arguments{
\item{contribution}{Signature contribution matrix}

\item{sig_order}{Character vector with the desired order of the signature names for plotting. Optional.}

\item{cluster_samples}{Hierarchically cluster samples based on eucledian distance. Default = T.}

\item{method}{The agglomeration method to be used for hierarchical clustering. This should be one of 
"ward.D", "ward.D2", "single", "complete", "average" (= UPGMA), "mcquitty" (= WPGMA), "median" (= WPGMC) 
or "centroid" (= UPGMC). Default = "complete".}

\item{plot_values}{Plot relative contribution values in heatmap. Default = F.}
}
\value{
Heatmap with relative contribution of each signature for each sample
}
\description{
Plot relative contribution of signatures in a heatmap
}
\examples{
## See the 'mut_matrix()' example for how we obtained the following
## mutation matrix.
mut_mat <- readRDS(system.file("states/mut_mat_data.rds",
                                package="MutationalPatterns"))

## Extracting signatures can be computationally intensive, so
## we use pre-computed data generated with the following command:

# nmf_res <- extract_signatures(mut_mat, rank = 2)

nmf_res <- readRDS(system.file("states/nmf_res_data.rds",
                    package="MutationalPatterns"))

## Set signature names as row names in the contribution matrix
rownames(nmf_res$contribution) = c("Signature A", "Signature B")

## Define signature order for plotting
sig_order = c("Signature B", "Signature A")


## Contribution heatmap with signatures in defined order
plot_contribution_heatmap(nmf_res$contribution, 
                          sig_order = c("Signature B", "Signature A"))

## Contribution heatmap without sample clustering
plot_contribution_heatmap(nmf_res$contribution, 
                          sig_order = c("Signature B", "Signature A"), 
                          cluster_samples = FALSE, method = "complete")

}
\seealso{
\code{\link{extract_signatures}},
\code{\link{mut_matrix}},
\code{\link{plot_contribution}}
}
