% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_contribution.R
\name{plot_contribution}
\alias{plot_contribution}
\title{Plot signature contribution barplot}
\usage{
plot_contribution(contribution, signatures, index = c(), coord_flip = FALSE,
  mode = "relative", palette = c())
}
\arguments{
\item{contribution}{Signature contribution matrix}

\item{signatures}{Signature matrix}

\item{index}{optional sample subset parameter}

\item{coord_flip}{Flip X and Y coordinates, default = FALSE}

\item{mode}{"relative" or "absolute"; to plot the relative contribution or
absolute number of mutations, default = "relative"}

\item{palette}{A color palette like c("#FF0000", "#00FF00", "9999CC") that
will be used as colors in the plot.  By default, ggplot2's colors are used
to generate a palette.}
}
\value{
Stacked barplot with contribution of each signature for each sample
}
\description{
Plot contribution of signatures
}
\examples{
## See the 'mut_matrix()' example for how we obtained the following
## mutation matrix.
mut_mat <- readRDS(system.file("states/mut_mat_data.rds",
                                package="MutationalPatterns"))

## Extracting signatures can be computationally intensive, so
## we use pre-computed data generated with the following command:
# nmf_res <- extract_signatures(mut_mat, rank = 2)

nmf_res <- readRDS(system.file("states/nmf_res_data.rds",
                    package="MutationalPatterns"))

## Optionally set column and row names.
colnames(nmf_res$signatures) = c("Signature A", "Signature B")
rownames(nmf_res$contribution) = c("Signature A", "Signature B")

## The following are examples of contribution plots.
plot_contribution(nmf_res$contribution,
                    nmf_res$signature,
                    mode = "relative")

plot_contribution(nmf_res$contribution,
                    nmf_res$signature,
                    mode = "absolute")

plot_contribution(nmf_res$contribution,
                    nmf_res$signature,
                    mode = "absolute",
                    index = c(1,2))

plot_contribution(nmf_res$contribution,
                    nmf_res$signature,
                    mode = "absolute",
                    coord_flip = TRUE)

}
\seealso{
\code{\link{extract_signatures}},
\code{\link{mut_matrix}}
}
