% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mut_matrix.R
\name{mut_matrix}
\alias{mut_matrix}
\title{Make mutation count matrix of 96 trinucleotides}
\usage{
mut_matrix(vcf_list, ref_genome)
}
\arguments{
\item{vcf_list}{List of collapsed vcf objects}

\item{ref_genome}{BSGenome reference genome object}
}
\value{
96 mutation count matrix
}
\description{
Make 96 trinucleotide mutation count matrix
}
\examples{
## See the 'read_vcfs_as_granges()' example for how we obtained the
## following data:
vcfs <- readRDS(system.file("states/read_vcfs_as_granges_output.rds",
                package="MutationalPatterns"))

## Load the corresponding reference genome.
ref_genome = "BSgenome.Hsapiens.UCSC.hg19"
library(ref_genome, character.only = TRUE)

## Construct a mutation matrix from the loaded VCFs in comparison to the
## ref_genome.
mut_mat <- mut_matrix(vcf_list = vcfs, ref_genome = ref_genome)

}
\seealso{
\code{\link{read_vcfs_as_granges}},
}
