% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_to_signatures.R
\name{fit_to_signatures}
\alias{fit_to_signatures}
\title{Find optimal nonnegative linear combination of mutation signatures to
reconstruct the mutation matrix.}
\usage{
fit_to_signatures(mut_matrix, signatures)
}
\arguments{
\item{mut_matrix}{96 mutation count matrix (dimensions: 96 mutations
X n samples)}

\item{signatures}{Signature matrix (dimensions: 96 mutations
X n signatures)}
}
\value{
Named list with signature contributions and reconstructed
mutation matrix
}
\description{
Find the linear combination of mutation signatures that most closely
reconstructs the mutation matrix by solving the nonnegative least-squares
constraints problem.
}
\examples{

## See the 'mut_matrix()' example for how we obtained the mutation matrix:
mut_mat <- readRDS(system.file("states/mut_mat_data.rds",
                    package="MutationalPatterns"))

## You can download the signatures from the COSMIC website:
# http://cancer.sanger.ac.uk/cancergenome/assets/signatures_probabilities.txt

## We copied the file into our package for your convenience.
filename <- system.file("extdata/signatures_probabilities.txt",
                        package="MutationalPatterns")
cancer_signatures <- read.table(filename, sep = "\\t", header = TRUE)

## Match the order to MutationalPatterns standard of mutation matrix
order = match(row.names(mut_mat), cancer_signatures$Somatic.Mutation.Type)
## Reorder cancer signatures dataframe
cancer_signatures = cancer_signatures[order,]
## Use trinucletiode changes names as row.names
## row.names(cancer_signatures) = cancer_signatures$Somatic.Mutation.Type
## Keep only 96 contributions of the signatures in matrix
cancer_signatures = as.matrix(cancer_signatures[,4:33])
## Rename signatures to number only
colnames(cancer_signatures) = as.character(1:30)


## Perform the fitting
fit_res <- fit_to_signatures(mut_mat, cancer_signatures)

}
\seealso{
\code{\link{mut_matrix}}
}
