% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{computeInfRV}
\alias{computeInfRV}
\title{Compute inferential relative variance (InfRV)}
\usage{
computeInfRV(y, pc = 5, shift = 0.01, meanVariance, useCounts = FALSE)
}
\arguments{
\item{y}{a SummarizedExperiment}

\item{pc}{a pseudocount parameter for the denominator}

\item{shift}{a final shift parameter}

\item{meanVariance}{logical, use pre-computed inferential mean
and variance assays instead of \code{counts} and
computed variance from \code{infReps}. If missing,
will use pre-computed mean and variance when present}

\item{useCounts}{logical, whether to use the MLE
count matrix for the mean instead of mean of inferential replicates.
this argument is for backwards compatability, as previous
versions used counts. Default is FALSE}
}
\value{
a SummarizedExperiment with \code{meanInfRV} in the metadata columns
}
\description{
\code{InfRV} is a useful quantity for comparing groups of features
(transcripts, genes, etc.) by inferential uncertainty.
This function provides computation of the mean InfRV over samples,
per feature, stored in \code{mcols(y)$meanInfRV}.
}
\details{
InfRV is defined in Zhu et al. (2019) as:
\eqn{\max(s^2 - \mu, 0) / \mu}, using the inferential
sample variance and sample mean. This formulation takes the
non-Poisson part of the inferential variance and scales by the
mean, which effectively stabilizes inferential uncertainty over
mean count. In practice, we also add \code{pc} to the denominator and
\code{shift} to the final quantity, to facilitate visualization.

This function also computes and adds the mean and variance of inferential
replicates, which can be useful ahead of \code{\link{plotInfReps}}.
Note that InfRV is not used in the \code{swish}
statistical method (for generating test statistics, p-values
or q-values), it is just for visualization.
}
\references{
Anqi Zhu, Avi Srivastava, Joseph G Ibrahim, Rob Patro, Michael I Love
"Nonparametric expression analysis using inferential replicate counts"
Nucleic Acids Research (2019). \url{https://doi.org/10.1093/nar/gkz622}
}
