% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbhelpers.R
\name{EnsDb}
\alias{EnsDb}
\title{Connect to an EnsDb object}
\usage{
EnsDb(x)
}
\arguments{
\item{x}{Either a character specifying the \emph{SQLite} database file, or
a \code{DBIConnection} to e.g. a MySQL database.}
}
\value{
A \code{\linkS4class{EnsDb}} object.
}
\description{
The \code{EnsDb} constructor function connects to the database
specified with argument \code{x} and returns a corresponding
\code{\linkS4class{EnsDb}} object.
}
\details{
By providing the connection to a MySQL database, it is possible
to use MySQL as the database backend and queries will be performed on that
database. Note however that this requires the package \code{RMySQL} to be
installed. In addition, the user needs to have access to a MySQL server
providing already an EnsDb database, or must have write privileges on a
MySQL server, in which case the \code{\link{useMySQL}} method can be used
to insert the annotations from an EnsDB package into a MySQL database.
}
\examples{
## "Standard" way to create an EnsDb object:
library(EnsDb.Hsapiens.v75)
EnsDb.Hsapiens.v75

## Alternatively, provide the full file name of a SQLite database file
dbfile <- system.file("extdata/EnsDb.Hsapiens.v75.sqlite", package = "EnsDb.Hsapiens.v75")
edb <- EnsDb(dbfile)
edb

## Third way: connect to a MySQL database
\dontrun{
library(RMySQL)
dbcon <- dbConnect(MySQL(), user = my_user, pass = my_pass, host = my_host, dbname = "ensdb_hsapiens_v75")
edb <- EnsDb(dbcon)
}
}
\author{
Johannes Rainer
}

